/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern.handler;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.extern.handler.ProcessInterface;
import de.neemann.digital.lang.Lang;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdIOInterface
implements ProcessInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(StdIOInterface.class);
    private static final String PREFIX = "Digital:";
    private static final int MAX_CONSOLE_LINES = 30;
    private static final long TIMEOUT = 5000L;
    private final Process process;
    private BufferedWriter writer;
    private Thread thread;
    private LinkedList<String> consoleOut;
    private final Object lock = new Object();
    private String dataFound;
    private boolean terminated = false;

    public StdIOInterface(Process process) {
        this.process = process;
        this.setInputOutputStream(process.getInputStream(), process.getOutputStream());
    }

    private void setInputOutputStream(InputStream in, OutputStream out) {
        this.setReaderWriter(new BufferedReader(new InputStreamReader(in)), new BufferedWriter(new OutputStreamWriter(out)));
    }

    private void setReaderWriter(BufferedReader reader, BufferedWriter writer) {
        this.writer = writer;
        this.consoleOut = new LinkedList();
        this.terminated = false;
        this.thread = new Thread(() -> {
            LOGGER.debug("reader-thread started");
            block8: while (true) {
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        this.consoleOut.add(line);
                        while (this.consoleOut.size() > 30) {
                            this.consoleOut.removeFirst();
                        }
                        if (!line.startsWith(PREFIX)) continue;
                        Object object = this.lock;
                        synchronized (object) {
                            while (this.dataFound != null) {
                                this.lock.wait();
                            }
                            this.dataFound = line;
                            this.lock.notify();
                            continue block8;
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.terminated = true;
                this.lock.notify();
            }
            LOGGER.debug("reader-thread terminated");
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                long startTime = System.currentTimeMillis();
                long time = 0L;
                while (this.dataFound == null && !this.terminated && time - startTime < 5000L) {
                    this.lock.wait(1000L);
                    time = System.currentTimeMillis();
                }
                if (time - startTime >= 5000L) {
                    throw new IOException(Lang.get("err_timeoutReadingData_O", this.getConsoleOut()));
                }
                String line = this.dataFound;
                this.dataFound = null;
                this.lock.notify();
                return line;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
    }

    @Override
    public void writeValues(ObservableValues values) throws IOException {
        try {
            for (ObservableValue v : values) {
                int bits = v.getBits();
                long value = v.getValue();
                long highZ = v.getHighZ();
                long mask = 1L;
                int i = 0;
                while (i < bits) {
                    if ((highZ & mask) != 0L) {
                        this.writer.write(90);
                    } else if ((value & mask) != 0L) {
                        this.writer.write(49);
                    } else {
                        this.writer.write(48);
                    }
                    mask <<= 1;
                    ++i;
                }
            }
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IOException(Lang.get("err_writingToStdOut_O", this.getConsoleOut()), e);
        }
    }

    @Override
    public void readValues(ObservableValues values) throws IOException {
        String line = this.readLine();
        if (line != null) {
            int pos = PREFIX.length();
            int len = line.length();
            for (ObservableValue v : values) {
                int bits = v.getBits();
                if (pos + bits > len) {
                    throw new IOException(Lang.get("err_notEnoughDataReceived_O", this.getConsoleOut()));
                }
                long value = 0L;
                long highZ = 0L;
                long mask = 1L;
                int i = 0;
                while (i < bits) {
                    char c = line.charAt(pos);
                    switch (c) {
                        case 'Z': 
                        case 'z': {
                            highZ |= mask;
                            break;
                        }
                        case '1': 
                        case 'H': {
                            value |= mask;
                            break;
                        }
                        case '0': 
                        case 'L': 
                        case 'U': 
                        case 'W': 
                        case 'X': 
                        case 'x': {
                            break;
                        }
                        default: {
                            throw new IOException(Lang.get("err_invalidCharacterReceived_N_O", "" + c, this.getConsoleOut()));
                        }
                    }
                    mask <<= 1;
                    ++pos;
                    ++i;
                }
                v.set(value, highZ);
            }
        } else {
            throw new IOException(Lang.get("err_processTerminatedUnexpected_O", this.getConsoleOutNoWarn(this.consoleOut)));
        }
    }

    public String getConsoleOutNoWarn(LinkedList<String> consoleOut) {
        return this.getConsoleOut();
    }

    private String getConsoleOut() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.consoleOut) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.thread.isAlive()) {
                throw new IOException(Lang.get("err_couldNotTerminateProcess", new Object[0]));
            }
        }
    }
}

