/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.flipflops;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.flipflops.FlipflopBit;

public class FlipflopRS
extends FlipflopBit {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("RS_FF", FlipflopRS.class, PinInfo.input("S"), PinInfo.input("C").setClock(), PinInfo.input("R")).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.LABEL).addAttribute(Keys.DEFAULT).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.VALUE_IS_PROBE);
    private ObservableValue sVal;
    private ObservableValue rVal;
    private ObservableValue clockVal;
    private boolean lastClock;

    public FlipflopRS(ElementAttributes attributes) {
        super(attributes, DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockVal.getBool();
        if (clock && !this.lastClock) {
            boolean s = this.sVal.getBool();
            boolean r = this.rVal.getBool();
            if (s) {
                if (r) {
                    this.setOut(Math.random() < 0.5);
                } else {
                    this.setOut(true);
                }
            } else if (r) {
                this.setOut(false);
            }
        }
        this.lastClock = clock;
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.sVal = ((ObservableValue)inputs.get(0)).checkBits(1, this, 0);
        this.clockVal = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
        this.rVal = ((ObservableValue)inputs.get(2)).checkBits(1, this, 2);
    }
}

