/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.lang.Lang;
import javax.swing.KeyStroke;

public class Button
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Button.class, new PinDescription[0]).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.ACTIVE_LOW).addAttribute(Keys.MAP_TO_KEY).addAttribute(Keys.ADD_VALUE_TO_GRAPH);
    private final ObservableValue output = new ObservableValue("out", 1).setPinDescription(DESCRIPTION);
    private final String label;
    private final boolean invert;
    private final boolean mapToKey;
    private final boolean showInGraph;
    private boolean pressed;

    public Button(ElementAttributes attributes) {
        this.label = attributes.get(Keys.LABEL);
        this.invert = attributes.get(Keys.ACTIVE_LOW);
        this.mapToKey = attributes.get(Keys.MAP_TO_KEY);
        this.output.setValue(this.invert ? 1 : 0);
        this.showInGraph = attributes.get(Keys.ADD_VALUE_TO_GRAPH);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        throw new NodeException(Lang.get("err_noInputsAvailable", new Object[0]), new ObservableValue[0]);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void registerNodes(Model model) {
        KeyStroke keyStroke;
        model.addSignal(new Signal(this.label, this.output).setShowInGraph(this.showInGraph));
        if (this.mapToKey && (keyStroke = KeyStroke.getKeyStroke(this.label.trim())) != null && keyStroke.getKeyCode() != 0) {
            model.addButtonToMap(this, keyStroke.getKeyCode());
        }
    }

    public void setPressed(boolean pressed) {
        if (pressed != this.pressed) {
            this.pressed = pressed;
            if (pressed ^ this.invert) {
                this.output.setValue(1L);
            } else {
                this.output.setValue(0L);
            }
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }
}

