/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.io.InValue;
import de.neemann.digital.lang.Lang;

public class In
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(In.class, new PinDescription[0]){

        @Override
        public String getDescription(ElementAttributes elementAttributes) {
            String d = Lang.evalMultilingualContent(elementAttributes.get(Keys.DESCRIPTION));
            if (d.length() > 0) {
                return d;
            }
            return super.getDescription(elementAttributes);
        }
    }.addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.INPUT_DEFAULT).addAttribute(Keys.IS_HIGH_Z).addAttribute(Keys.AVOID_ACTIVE_LOW).addAttribute(Keys.DESCRIPTION).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.PINNUMBER).addAttribute(Keys.ADD_VALUE_TO_GRAPH).addAttribute(Keys.IN_OUT_SMALL).supportsHDL();
    private final ObservableValue output;
    private final String label;
    private final String pinNumber;
    private final ValueFormatter formatter;
    private final boolean showInGraph;
    private Model model;
    private ObservableValue input;

    public In(ElementAttributes attributes) {
        InValue value = attributes.get(Keys.INPUT_DEFAULT);
        this.pinNumber = attributes.get(Keys.PINNUMBER);
        this.output = new ObservableValue("out", attributes.get(Keys.BITS)).setPinDescription(DESCRIPTION).setPinNumber(this.pinNumber);
        if (attributes.get(Keys.IS_HIGH_Z).booleanValue() || value.isHighZ()) {
            this.output.setBidirectional();
        }
        if (value.isHighZ()) {
            this.output.setToHighZ();
        } else {
            this.output.setValue(value.getValue());
        }
        this.label = attributes.getLabel();
        this.formatter = attributes.getValueFormatter();
        this.showInGraph = attributes.get(Keys.ADD_VALUE_TO_GRAPH);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = (ObservableValue)inputs.get(0);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void registerNodes(Model model) {
        model.addInput(new Signal(this.label, this.output, this.output::set).setPinNumber(this.pinNumber).setBidirectionalReader(this.input).setShowInGraph(this.showInGraph).setFormat(this.formatter));
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }
}

