/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.io.MIDIHelper;
import javax.sound.midi.MidiChannel;

public class MIDI
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(MIDI.class, new PinDescription[0]){

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) throws NodeException {
            if (elementAttributes.get(Keys.MIDI_PROG_CHANGE).booleanValue()) {
                return new PinDescriptions(new PinDescription[]{PinInfo.input("N"), PinInfo.input("V"), PinInfo.input("OnOff"), PinInfo.input("PC"), PinInfo.input("en"), PinInfo.input("C").setClock()}).setLangKey(this.getPinLangKey());
            }
            return new PinDescriptions(new PinDescription[]{PinInfo.input("N"), PinInfo.input("V"), PinInfo.input("OnOff"), PinInfo.input("en"), PinInfo.input("C").setClock()}).setLangKey(this.getPinLangKey());
        }
    }.addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.MIDI_CHANNEL).addAttribute(Keys.MIDI_INSTRUMENT).addAttribute(Keys.MIDI_PROG_CHANGE);
    private final int chanNum;
    private final String instrument;
    private final boolean progChangeEnable;
    private ObservableValue note;
    private ObservableValue volume;
    private ObservableValue clock;
    private ObservableValue onOff;
    private ObservableValue en;
    private ObservableValue progChange;
    private MidiChannel channel;
    private boolean lastCl = false;

    public MIDI(ElementAttributes attributes) {
        this.chanNum = attributes.get(Keys.MIDI_CHANNEL) - 1;
        this.instrument = attributes.get(Keys.MIDI_INSTRUMENT);
        this.progChangeEnable = attributes.get(Keys.MIDI_PROG_CHANGE);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.note = ((ObservableValue)inputs.get(0)).checkBits(7, this, 0);
        this.volume = ((ObservableValue)inputs.get(1)).checkBits(7, this, 1);
        this.onOff = ((ObservableValue)inputs.get(2)).checkBits(1, this, 2);
        if (this.progChangeEnable) {
            this.progChange = ((ObservableValue)inputs.get(3)).checkBits(1, this, 3);
            this.en = ((ObservableValue)inputs.get(4)).checkBits(1, this, 4);
            this.clock = ((ObservableValue)inputs.get(5)).checkBits(1, this, 5).addObserverToValue(this);
        } else {
            this.en = ((ObservableValue)inputs.get(3)).checkBits(1, this, 3);
            this.clock = ((ObservableValue)inputs.get(4)).checkBits(1, this, 4).addObserverToValue(this);
        }
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void readInputs() throws NodeException {
        boolean cl = this.clock.getBool();
        if (!this.lastCl && cl && this.en.getBool()) {
            int note = (int)this.note.getValue();
            if (this.progChange != null && this.progChange.getBool()) {
                this.channel.programChange(note);
            } else if (this.onOff.getBool()) {
                int v = (int)this.volume.getValue();
                this.channel.noteOn(note, v);
            } else {
                this.channel.noteOff(note);
            }
        }
        this.lastCl = cl;
    }

    @Override
    public void writeOutputs() throws NodeException {
    }

    @Override
    public void init(Model model) throws NodeException {
        this.channel = MIDIHelper.getInstance().getChannel(this.chanNum, this.instrument, model);
    }
}

