/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class PinControl
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(PinControl.class, PinInfo.input("wr"), PinInfo.input("oe")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.MIRROR).supportsHDL();
    private final int bits;
    private final ObservableValue rdValue;
    private final ObservableValue outWriteValue;
    private ObservableValue wrValue;
    private ObservableValue oeValue;
    private ObservableValue outReadValue;
    private long wr;
    private boolean oe;
    private long outRead;

    public PinControl(ElementAttributes attr) {
        this.bits = attr.getBits();
        this.rdValue = new ObservableValue("rd", this.bits).setPinDescription(DESCRIPTION);
        this.outWriteValue = new ObservableValue("pin", this.bits).setPinDescription(DESCRIPTION).setBidirectional();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.wrValue = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this);
        this.oeValue = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this);
        this.outReadValue = ((ObservableValue)inputs.get(2)).addObserverToValue(this).checkBits(this.bits, this);
    }

    @Override
    public void readInputs() throws NodeException {
        this.wr = this.wrValue.getValue();
        this.oe = this.oeValue.getBool();
        this.outRead = this.outReadValue.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.oe) {
            this.outWriteValue.setValue(this.wr);
            this.rdValue.setValue(this.wr);
        } else {
            this.outWriteValue.setToHighZ();
            this.rdValue.setValue(this.outRead);
        }
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.rdValue, this.outWriteValue);
    }
}

