/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;

public class PowerSupply
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(PowerSupply.class, PinInfo.input("VDD"), PinInfo.input("GND")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL);
    private ObservableValue vcc;
    private ObservableValue gnd;

    public PowerSupply(ElementAttributes attributes) {
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.vcc = ((ObservableValue)inputs.get(0)).checkBits(1, null, 0).addObserverToValue(this);
        this.gnd = ((ObservableValue)inputs.get(1)).checkBits(1, null, 1).addObserverToValue(this);
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void readInputs() throws NodeException {
        if (this.vcc.getValue() != 1L || this.vcc.isHighZ()) {
            throw new NodeException(Lang.get("err_errorInPowerSupply", "VCC"), this, 0, this.vcc.asList());
        }
        if (this.gnd.getValue() != 0L || this.gnd.isHighZ()) {
            throw new NodeException(Lang.get("err_errorInPowerSupply", "GND"), this, 1, this.gnd.asList());
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
    }
}

