/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.io.ProbeMode;

public class Probe
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("Probe", Probe.class, PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.PROBE_MODE).addAttribute(Keys.ADD_VALUE_TO_GRAPH);
    private final String label;
    private final ValueFormatter formatter;
    private final boolean showInGraph;
    private final ProbeMode mode;
    private ObservableValue value;

    public Probe(ElementAttributes attributes) {
        this.label = attributes.get(Keys.LABEL);
        this.formatter = attributes.getValueFormatter();
        this.showInGraph = attributes.get(Keys.ADD_VALUE_TO_GRAPH);
        this.mode = attributes.get(Keys.PROBE_MODE);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.value = this.mode == ProbeMode.VALUE ? (ObservableValue)inputs.get(0) : new Counter(this.label, ((ObservableValue)inputs.get(0)).checkBits(1, null, 0), this.mode).value;
    }

    public ObservableValue getValue() {
        return this.value;
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void registerNodes(Model model) {
        model.addSignal(new Signal(this.label, this.value).setShowInGraph(this.showInGraph).setFormat(this.formatter).setTestOutput());
        model.registerGlobalValue(this.label, this.value);
    }

    private static final class Counter
    implements Observer {
        private final ObservableValue in;
        private final ObservableValue value;
        private final ProbeMode mode;
        private boolean last;
        private long counter;

        private Counter(String label, ObservableValue value, ProbeMode mode) {
            this.in = value;
            this.last = this.in.getBool();
            this.value = new ObservableValue(label, 64);
            value.addObserver(this);
            this.mode = mode;
        }

        @Override
        public void hasChanged() {
            boolean now = this.in.getBool();
            boolean inc = false;
            switch (this.mode) {
                case UP: {
                    inc = !this.last & now;
                    break;
                }
                case DOWN: {
                    inc = this.last & !now;
                    break;
                }
                case BOTH: {
                    inc = this.last ^ now;
                }
            }
            this.last = now;
            if (inc) {
                this.value.setValue(++this.counter);
            }
        }
    }
}

