/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class StepperMotorUnipolar
extends Node
implements Element {
    public static final int STEPS = 72;
    private static final int SWITCH_SIZE = 2;
    private static final boolean[] STATE_VALID;
    private static final int[][] STEP_TABLE;
    public static final ElementTypeDescription DESCRIPTION;
    private final ObservableValue s0 = new ObservableValue("S0", 1).setPinDescription(DESCRIPTION);
    private final ObservableValue s1 = new ObservableValue("S1", 1).setPinDescription(DESCRIPTION);
    private final boolean invertOut;
    private ObservableValue p0;
    private ObservableValue p1;
    private ObservableValue p2;
    private ObservableValue p3;
    private ObservableValue com;
    private int lastState;
    private int pos;
    private int sequenceError;
    private boolean stateError;

    static {
        boolean[] blArray = new boolean[16];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[6] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[12] = true;
        STATE_VALID = blArray;
        int[][] nArrayArray = new int[16][];
        nArrayArray[0] = new int[16];
        int[] nArray = new int[16];
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[8] = -2;
        nArray[9] = -1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = -2;
        nArray2[3] = -1;
        nArray2[4] = 2;
        nArray2[6] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = -1;
        nArray3[2] = 1;
        nArray3[6] = 2;
        nArray3[9] = -2;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[16];
        nArray4[2] = -2;
        nArray4[6] = -1;
        nArray4[8] = 2;
        nArray4[12] = 1;
        nArrayArray[4] = nArray4;
        nArrayArray[5] = new int[16];
        int[] nArray5 = new int[16];
        nArray5[2] = -1;
        nArray5[3] = -2;
        nArray5[4] = 1;
        nArray5[12] = 2;
        nArrayArray[6] = nArray5;
        nArrayArray[7] = new int[16];
        int[] nArray6 = new int[16];
        nArray6[1] = 2;
        nArray6[4] = -2;
        nArray6[9] = 1;
        nArray6[12] = -1;
        nArrayArray[8] = nArray6;
        int[] nArray7 = new int[16];
        nArray7[1] = 1;
        nArray7[3] = 2;
        nArray7[8] = -1;
        nArray7[12] = -2;
        nArrayArray[9] = nArray7;
        nArrayArray[10] = new int[16];
        nArrayArray[11] = new int[16];
        int[] nArray8 = new int[16];
        nArray8[4] = -1;
        nArray8[6] = -2;
        nArray8[8] = 1;
        nArray8[9] = 2;
        nArrayArray[12] = nArray8;
        nArrayArray[13] = new int[16];
        nArrayArray[14] = new int[16];
        nArrayArray[15] = new int[16];
        STEP_TABLE = nArrayArray;
        DESCRIPTION = new ElementTypeDescription(StepperMotorUnipolar.class, PinInfo.input("P0"), PinInfo.input("P1"), PinInfo.input("P2"), PinInfo.input("P3"), PinInfo.input("com")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.INVERT_OUTPUT);
    }

    public StepperMotorUnipolar(ElementAttributes attr) {
        this.invertOut = attr.get(Keys.INVERT_OUTPUT);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.p0 = ((ObservableValue)inputs.get(0)).checkBits(1, this).addObserverToValue(this);
        this.p1 = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
        this.p2 = ((ObservableValue)inputs.get(2)).checkBits(1, this).addObserverToValue(this);
        this.p3 = ((ObservableValue)inputs.get(3)).checkBits(1, this).addObserverToValue(this);
        this.com = ((ObservableValue)inputs.get(4)).checkBits(1, this).addObserverToValue(this);
    }

    @Override
    public void readInputs() throws NodeException {
        int state = this.getState();
        int step = STEP_TABLE[this.lastState][state];
        this.pos = this.reverse() ? (this.pos -= step) : (this.pos += step);
        if (this.pos < 0) {
            this.pos += 72;
        } else if (this.pos >= 72) {
            this.pos -= 72;
        }
        boolean stateValid = STATE_VALID[state];
        if (step == 0 && STATE_VALID[this.lastState] && stateValid) {
            this.sequenceError += 8;
            if (this.sequenceError > 8) {
                this.sequenceError = 8;
            }
        } else if (this.sequenceError > 0) {
            --this.sequenceError;
        }
        boolean bl = this.stateError = state != 0 && !stateValid;
        if (stateValid) {
            this.lastState = state;
        }
    }

    protected boolean reverse() {
        return this.com.getBool();
    }

    protected int getState() {
        if (this.com.isHighZ()) {
            return 0;
        }
        boolean comIn = this.com.getBool();
        return (this.isCurrent(this.p0, comIn) ? 1 : 0) | (this.isCurrent(this.p1, comIn) ? 2 : 0) | (this.isCurrent(this.p2, comIn) ? 4 : 0) | (this.isCurrent(this.p3, comIn) ? 8 : 0);
    }

    private boolean isCurrent(ObservableValue phase, boolean comIn) {
        if (phase.isHighZ()) {
            return false;
        }
        return phase.getBool() ^ comIn;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.s0.setBool(this.invertOut ^ (this.pos < 2 || this.pos > 70));
        this.s1.setBool(this.invertOut ^ (this.pos > 34 && this.pos < 38));
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isError() {
        return this.sequenceError > 0 || this.stateError;
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.s0, this.s1);
    }
}

