/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io.telnet;

import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.io.telnet.ByteBuffer;
import de.neemann.digital.core.io.telnet.Telnet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class Server {
    private final ServerSocket serverSocket;
    private final ByteBuffer buffer = new ByteBuffer(1024);
    private final ServerThread serverThread;
    private boolean telnetEscape;
    private ClientThread client;
    private Telnet telnet;
    private SyncAccess syncAccess;

    Server(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.serverThread = new ServerThread();
        this.serverThread.start();
    }

    void send(int value) {
        if (this.client != null) {
            this.client.send(value);
        }
    }

    int getData() {
        return this.buffer.peek();
    }

    void deleteOldest() {
        this.buffer.delete();
    }

    void deleteAll() {
        this.buffer.deleteAll();
    }

    public void setTelnetNode(Telnet telnet, SyncAccess syncAccess) {
        this.telnet = telnet;
        this.syncAccess = syncAccess;
    }

    boolean hasData() {
        return this.buffer.hasData();
    }

    private void setClient(ClientThread client) {
        this.client = client;
    }

    void setTelnetEscape(boolean telnetEscape) {
        this.telnetEscape = telnetEscape;
    }

    private void dataReceived(int data) {
        if (this.syncAccess != null) {
            this.syncAccess.modify(() -> {
                this.buffer.put((byte)data);
                this.telnet.hasChanged();
            });
        }
    }

    boolean isDead() {
        return !this.serverThread.isAlive();
    }

    private static final class ClientThread
    extends Thread {
        private static final int ECHO = 1;
        private static final int SGA = 3;
        private static final int WILL = 251;
        private static final int WONT = 252;
        private static final int DO = 253;
        private static final int DONT = 254;
        private static final int IAC = 255;
        private final InputStream in;
        private final OutputStream out;
        private final Socket client;
        private final Server server;

        private ClientThread(Socket client, Server server) throws IOException {
            this.setDaemon(true);
            this.in = client.getInputStream();
            this.out = client.getOutputStream();
            if (server.telnetEscape) {
                this.out.write(255);
                this.out.write(251);
                this.out.write(3);
                this.out.write(255);
                this.out.write(251);
                this.out.write(1);
                this.out.flush();
            }
            this.client = client;
            this.server = server;
        }

        @Override
        public void run() {
            try {
                int data;
                while ((data = this.in.read()) >= 0) {
                    if (data == 255 && this.server.telnetEscape) {
                        int command = this.in.read();
                        int n = this.in.read();
                        continue;
                    }
                    this.server.dataReceived(data);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void send(int value) {
            try {
                this.out.write(value);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    this.client.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    private final class ServerThread
    extends Thread {
        private ServerThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket client = Server.this.serverSocket.accept();
                    ClientThread cl = new ClientThread(client, Server.this);
                    cl.start();
                    Server.this.setClient(cl);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

