/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io.telnet;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.io.telnet.Server;
import de.neemann.digital.core.io.telnet.ServerHolder;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;
import java.io.IOException;

public class Telnet
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Telnet.class, PinInfo.input("in"), PinInfo.input("C").setClock(), PinInfo.input("wr"), PinInfo.input("rd")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.TELNET_ESCAPE).addAttribute(Keys.PORT);
    private final ObservableValue dataOut = new ObservableValue("out", 8).setToHighZ().setPinDescription(DESCRIPTION);
    private final ObservableValue dataAvail = new ObservableValue("av", 1).setPinDescription(DESCRIPTION);
    private final int port;
    private final boolean telnetEscape;
    private ObservableValue dataIn;
    private ObservableValue clockValue;
    private ObservableValue writeEnable;
    private ObservableValue readEnableValue;
    private Server server;
    private boolean lastClock;
    private boolean readEnable;

    public Telnet(ElementAttributes attributes) {
        this.port = attributes.get(Keys.PORT);
        this.telnetEscape = attributes.get(Keys.TELNET_ESCAPE);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.dataIn = ((ObservableValue)inputs.get(0)).checkBits(8, this, 0);
        this.clockValue = ((ObservableValue)inputs.get(1)).checkBits(1, this, 1).addObserverToValue(this);
        this.writeEnable = ((ObservableValue)inputs.get(2)).checkBits(1, this, 2);
        this.readEnableValue = ((ObservableValue)inputs.get(3)).checkBits(1, this, 3).addObserverToValue(this);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockValue.getBool();
        this.readEnable = this.readEnableValue.getBool();
        if (clock & !this.lastClock) {
            if (this.writeEnable.getBool()) {
                this.server.send((int)this.dataIn.getValue());
            }
            if (this.readEnable) {
                this.server.deleteOldest();
            }
        }
        this.lastClock = clock;
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.readEnable) {
            this.dataOut.setValue(this.server.getData());
        } else {
            this.dataOut.setToHighZ();
        }
        this.dataAvail.setBool(this.server.hasData());
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return new ObservableValues(this.dataOut, this.dataAvail);
    }

    @Override
    public void init(Model model) throws NodeException {
        try {
            this.server = ServerHolder.INSTANCE.getServer(this.port);
        }
        catch (IOException e) {
            throw new NodeException(Lang.get("err_couldNotCreateServer", new Object[0]), e);
        }
        this.server.setTelnetEscape(this.telnetEscape);
        this.server.setTelnetNode(this, model);
    }
}

