/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Bits;
import de.neemann.digital.hdl.hgs.HGSArray;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public class DataField
implements HGSArray {
    private long[] data;
    private final transient ArrayList<DataListener> listeners = new ArrayList();

    public DataField() {
        this(0);
    }

    public DataField(int size) {
        this(new long[size]);
    }

    public DataField(DataField data) {
        this.data = Arrays.copyOf(data.data, data.data.length);
    }

    public DataField(long[] data) {
        this.data = data;
    }

    public void saveTo(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            this.saveTo(w);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void saveTo(Writer writer) throws IOException {
        this.trim();
        BufferedWriter w = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        w.write("v2.0 raw");
        w.newLine();
        if (this.data.length > 0) {
            long akt = this.data[0];
            int count = 1;
            int i = 1;
            while (i < this.data.length) {
                long now = this.data[i];
                if (now == akt) {
                    ++count;
                } else {
                    this.writeChunk(w, akt, count);
                    akt = now;
                    count = 1;
                }
                ++i;
            }
            this.writeChunk(w, akt, count);
        }
        w.flush();
    }

    private void writeChunk(BufferedWriter w, long data, int count) throws IOException {
        if (count < 4) {
            int j = 0;
            while (j < count) {
                w.write(Long.toHexString(data));
                w.newLine();
                ++j;
            }
        } else {
            w.write(Integer.toString(count));
            w.write(42);
            w.write(Long.toHexString(data));
            w.newLine();
        }
    }

    public void clearAll() {
        if (this.data != null) {
            Arrays.fill(this.data, 0L);
        }
        this.fireChanged(-1);
    }

    public boolean setData(int addr, long value) {
        if (addr >= this.data.length) {
            int newLen = addr * 2;
            if (newLen < 32) {
                newLen = 32;
            }
            this.data = Arrays.copyOf(this.data, newLen);
        }
        if (this.data[addr] != value) {
            this.data[addr] = value;
            this.fireChanged(addr);
            return true;
        }
        return false;
    }

    public long getDataWord(int addr) {
        if (addr >= this.data.length) {
            return 0L;
        }
        return this.data[addr];
    }

    public int trim() {
        return this.trim(this.data.length);
    }

    private int trim(int size) {
        if (size > this.data.length) {
            size = this.data.length;
        }
        while (size > 0 && this.data[size - 1] == 0L) {
            --size;
        }
        if (size < this.data.length) {
            this.data = Arrays.copyOf(this.data, size);
        }
        return this.data.length;
    }

    public DataField trimValues(int addrBits, int dataBits) {
        this.trim(1 << addrBits);
        long mask = Bits.mask(dataBits);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = this.data[i] & mask;
            ++i;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.trim() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DataListener l) {
        ArrayList<DataListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DataListener l) {
        ArrayList<DataListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChanged(int addr) {
        ArrayList<DataListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (DataListener l : this.listeners) {
                l.valueChanged(addr);
            }
        }
    }

    public void setDataFrom(DataField dataField) {
        this.data = Arrays.copyOf(dataField.data, dataField.data.length);
        this.fireChanged(-1);
    }

    @Override
    public int hgsArraySize() {
        return this.data.length;
    }

    @Override
    public Object hgsArrayGet(int i) {
        return this.getDataWord(i);
    }

    public long[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataField dataField = (DataField)o;
        return Arrays.equals(this.data, dataField.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public static interface DataListener {
        public void valueChanged(int var1);
    }
}

