/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMDualPort;
import de.neemann.digital.core.memory.rom.ROMInterface;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.gui.components.CircuitModifier;
import de.neemann.digital.gui.components.modification.ModifyAttribute;

public class EEPROMDualPort
extends RAMDualPort
implements ROMInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(EEPROMDualPort.class, PinInfo.input("A"), PinInfo.input("Din"), PinInfo.input("str"), PinInfo.input("C").setClock(), PinInfo.input("ld")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.IS_PROGRAM_MEMORY).addAttribute(Keys.LABEL).addAttribute(Keys.DATA);
    private final ElementAttributes attr;
    private DataField memory;

    public EEPROMDualPort(ElementAttributes attr) {
        super(attr);
        this.attr = attr;
    }

    @Override
    protected DataField createDataField(ElementAttributes attr, int size) {
        this.memory = new DataField(attr.get(Keys.DATA));
        return this.memory;
    }

    @Override
    public void enableCircuitModification(VisualElement visualElement, CircuitModifier circuitModifier) {
        this.getModel().addObserver(event -> {
            DataField orig;
            if (event.getType() == ModelEventType.CLOSED && !(orig = this.attr.get(Keys.DATA)).equals(this.memory)) {
                circuitModifier.modify(new ModifyAttribute<DataField>(visualElement, Keys.DATA, this.memory));
            }
        }, ModelEventType.CLOSED, new ModelEventType[0]);
    }
}

