/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.lang.Lang;

public class LookUpTable
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(LookUpTable.class, new PinDescription[0]){

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) {
            int size = elementAttributes.get(Keys.INPUT_COUNT);
            PinDescription[] names = new PinDescription[size];
            int i = 0;
            while (i < size) {
                names[i] = PinInfo.input(Integer.toString(i), Lang.get("elem_LookUpTable_pin_in", i));
                ++i;
            }
            return new PinDescriptions(names);
        }
    }.addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.LUT_INPUT_COUNT).addAttribute(Keys.LABEL).addAttribute(Keys.DATA).supportsHDL();
    private final DataField data;
    private final ObservableValue output;
    private ObservableValues inputs;
    private int addr;

    public LookUpTable(ElementAttributes attr) {
        int bits = attr.get(Keys.BITS);
        this.output = new ObservableValue("out", bits).setPinDescription(DESCRIPTION);
        this.data = attr.get(Keys.DATA);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.inputs = inputs;
        for (ObservableValue v : inputs) {
            v.checkBits(1, this).addObserverToValue(this);
        }
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void readInputs() throws NodeException {
        this.addr = 0;
        int mask = 1;
        int i = 0;
        while (i < this.inputs.size()) {
            if (((ObservableValue)this.inputs.get(i)).getValue() > 0L) {
                this.addr |= mask;
            }
            mask *= 2;
            ++i;
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.output.setValue(this.data.getDataWord(this.addr));
    }
}

