/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMInterface;

public class RAMDualAccess
extends Node
implements Element,
RAMInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(RAMDualAccess.class, PinInfo.input("str"), PinInfo.input("C").setClock(), PinInfo.input("ld"), PinInfo.input("1A"), PinInfo.input("1Din"), PinInfo.input("2A")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.IS_PROGRAM_MEMORY).addAttribute(Keys.LABEL).supportsHDL();
    private final DataField memory;
    private final ObservableValue out1;
    private final ObservableValue out2;
    private final int addrBits;
    private final int bits;
    private final String label;
    private final int size;
    private final boolean isProgramMemory;
    private ObservableValue addr1In;
    private ObservableValue data1In;
    private ObservableValue str1In;
    private ObservableValue clk1In;
    private ObservableValue ld1In;
    private ObservableValue addr2In;
    private int addr1;
    private int addr2;
    private boolean lastClk = false;
    private boolean ld;

    public RAMDualAccess(ElementAttributes attr) {
        super(true);
        this.bits = attr.get(Keys.BITS);
        this.out1 = new ObservableValue("1D", this.bits).setToHighZ().setPinDescription(DESCRIPTION);
        this.out2 = new ObservableValue("2D", this.bits).setPinDescription(DESCRIPTION);
        this.addrBits = attr.get(Keys.ADDR_BITS);
        this.size = 1 << this.addrBits;
        this.memory = new DataField(this.size);
        this.label = attr.getLabel();
        this.isProgramMemory = attr.isProgramMemory();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.str1In = ((ObservableValue)inputs.get(0)).checkBits(1, this);
        this.clk1In = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
        this.ld1In = ((ObservableValue)inputs.get(2)).checkBits(1, this).addObserverToValue(this);
        this.addr1In = ((ObservableValue)inputs.get(3)).checkBits(this.addrBits, this).addObserverToValue(this);
        this.data1In = ((ObservableValue)inputs.get(4)).checkBits(this.bits, this);
        this.addr2In = ((ObservableValue)inputs.get(5)).checkBits(this.addrBits, this).addObserverToValue(this);
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.out1, this.out2);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean str;
        long data = 0L;
        boolean clk = this.clk1In.getBool();
        if (!this.lastClk && clk) {
            str = this.str1In.getBool();
            if (str) {
                data = this.data1In.getValue();
            }
        } else {
            str = false;
        }
        this.ld = this.ld1In.getBool();
        if (this.ld || str) {
            this.addr1 = (int)this.addr1In.getValue();
        }
        if (str) {
            this.memory.setData(this.addr1, data);
        }
        this.addr2 = (int)this.addr2In.getValue();
        this.lastClk = clk;
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.ld) {
            this.out1.setValue(this.memory.getDataWord(this.addr1));
        } else {
            this.out1.setToHighZ();
        }
        this.out2.setValue(this.memory.getDataWord(this.addr2));
    }

    @Override
    public DataField getMemory() {
        return this.memory;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getAddrBits() {
        return this.addrBits;
    }

    @Override
    public boolean isProgramMemory() {
        return this.isProgramMemory;
    }

    @Override
    public void setProgramMemory(DataField dataField) {
        this.memory.setDataFrom(dataField);
    }
}

