/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMInterface;

public class RAMDualPort
extends Node
implements Element,
RAMInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(RAMDualPort.class, PinInfo.input("A"), PinInfo.input("Din"), PinInfo.input("str"), PinInfo.input("C").setClock(), PinInfo.input("ld")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.IS_PROGRAM_MEMORY).addAttribute(Keys.LABEL).supportsHDL();
    private DataField memory;
    private final ValueFormatter formatter;
    private final ObservableValue output;
    private final int addrBits;
    private final int bits;
    private final String label;
    private final int size;
    private final boolean isProgramMemory;
    private ObservableValue addrIn;
    private ObservableValue dataIn;
    private ObservableValue strIn;
    private ObservableValue clkIn;
    private ObservableValue ldIn;
    private int addr;
    private boolean lastClk = false;
    private boolean ld;

    public RAMDualPort(ElementAttributes attr) {
        super(true);
        this.bits = attr.get(Keys.BITS);
        this.output = this.createOutput();
        this.addrBits = attr.get(Keys.ADDR_BITS);
        this.size = 1 << this.addrBits;
        this.memory = this.createDataField(attr, this.size);
        this.label = attr.getLabel();
        this.isProgramMemory = attr.isProgramMemory();
        this.formatter = attr.getValueFormatter();
    }

    protected ObservableValue createOutput() {
        return new ObservableValue("D", this.bits).setToHighZ().setPinDescription(DESCRIPTION);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.setAddrIn((ObservableValue)inputs.get(0));
        this.setDataIn((ObservableValue)inputs.get(1));
        this.setStrIn((ObservableValue)inputs.get(2));
        this.setClkIn((ObservableValue)inputs.get(3));
        this.setLdIn((ObservableValue)inputs.get(4));
    }

    protected DataField createDataField(ElementAttributes attr, int size) {
        return new DataField(size);
    }

    protected void setAddrIn(ObservableValue addrIn) throws BitsException {
        this.addrIn = addrIn.checkBits(this.addrBits, this).addObserverToValue(this);
    }

    protected void setDataIn(ObservableValue dataIn) throws BitsException {
        this.dataIn = dataIn.checkBits(this.bits, this);
    }

    protected void setStrIn(ObservableValue strIn) throws BitsException {
        this.strIn = strIn.checkBits(1, this);
    }

    protected void setClkIn(ObservableValue clkIn) throws BitsException {
        this.clkIn = clkIn.checkBits(1, this).addObserverToValue(this);
    }

    protected void setLdIn(ObservableValue ldIn) throws BitsException {
        this.ldIn = ldIn.checkBits(1, this).addObserverToValue(this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void readInputs() throws NodeException {
        boolean str;
        long data = 0L;
        boolean clk = this.clkIn.getBool();
        if (!this.lastClk && clk) {
            str = this.strIn.getBool();
            if (str) {
                data = this.dataIn.getValue();
            }
        } else {
            str = false;
        }
        this.ld = this.ldIn.getBool();
        if (this.ld || str) {
            this.addr = (int)this.addrIn.getValue();
        }
        if (str) {
            this.memory.setData(this.addr, data);
        }
        this.lastClk = clk;
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.ld) {
            this.output.setValue(this.memory.getDataWord(this.addr));
        } else {
            this.output.setToHighZ();
        }
    }

    @Override
    public ValueFormatter getValueFormatter() {
        return this.formatter;
    }

    public void setData(DataField data) {
        this.memory = data;
    }

    @Override
    public DataField getMemory() {
        return this.memory;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getAddrBits() {
        return this.addrBits;
    }

    @Override
    public boolean isProgramMemory() {
        return this.isProgramMemory;
    }

    @Override
    public void setProgramMemory(DataField dataField) {
        this.memory.setDataFrom(dataField);
    }
}

