/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.ProgramCounter;
import de.neemann.digital.core.stats.Countable;

public class Register
extends Node
implements Element,
Countable,
ProgramCounter {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Register.class, PinInfo.input("D"), PinInfo.input("C").setClock(), PinInfo.input("en")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.IS_PROGRAM_COUNTER).addAttribute(Keys.VALUE_IS_PROBE).supportsHDL();
    private final int bits;
    private final boolean isProbe;
    private final String label;
    private final boolean isProgramCounter;
    private final ObservableValue q;
    private ObservableValue dVal;
    private ObservableValue clockVal;
    private ObservableValue enableVal;
    private boolean lastClock;
    private long value;
    private boolean enable;

    public Register(ElementAttributes attributes) {
        super(true);
        this.bits = attributes.getBits();
        this.q = new ObservableValue("Q", this.bits).setPinDescription(DESCRIPTION);
        this.isProbe = attributes.get(Keys.VALUE_IS_PROBE);
        this.label = attributes.get(Keys.LABEL);
        this.isProgramCounter = attributes.get(Keys.IS_PROGRAM_COUNTER);
    }

    @Override
    public void readInputs() throws NodeException {
        this.enable = this.enableVal.getBool();
        boolean clock = this.clockVal.getBool();
        if (clock && !this.lastClock && this.enable) {
            this.value = this.dVal.getValue();
        }
        this.lastClock = clock;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.q.setValue(this.value);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.dVal = ((ObservableValue)inputs.get(0)).checkBits(this.bits, this);
        this.clockVal = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this);
        this.enableVal = ((ObservableValue)inputs.get(2)).checkBits(1, this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.q.asList();
    }

    @Override
    public void registerNodes(Model model) {
        super.registerNodes(model);
        if (this.isProbe) {
            model.addSignal(new Signal(this.label, this.q, (value, highZ) -> this.setValue(value)).setTestOutput());
        }
    }

    @Override
    public boolean isProgramCounter() {
        return this.isProgramCounter;
    }

    @Override
    public long getProgramCounter() {
        return this.value;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long v) {
        this.value = v;
        this.q.setValue(this.value);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isEnabled() {
        return this.enable;
    }
}

