/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory.importer;

import de.neemann.digital.core.memory.importer.ByteArray;
import de.neemann.digital.core.memory.importer.ValueArray;

public class ByteArrayFromValueArray
implements ByteArray {
    private final ValueArray valueArray;
    private final int div;
    private final boolean bigEndian;

    public ByteArrayFromValueArray(ValueArray valueArray) {
        this(valueArray, false);
    }

    public ByteArrayFromValueArray(ValueArray valueArray, boolean bigEndian) {
        this.valueArray = valueArray;
        this.bigEndian = bigEndian;
        this.div = valueArray.getBytesPerValue();
    }

    @Override
    public void set(int addr, int aByte) {
        int a = addr / this.div;
        int b = addr % this.div;
        if (this.bigEndian) {
            b = this.div - b - 1;
        }
        long val = this.valueArray.get(a);
        this.valueArray.set(a, val |= ((long)aByte & 0xFFL) << b * 8);
    }
}

