/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory.importer;

import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.importer.BinReader;
import de.neemann.digital.core.memory.importer.ByteArrayFromValueArray;
import de.neemann.digital.core.memory.importer.DataFieldValueArray;
import de.neemann.digital.core.memory.importer.IntelHexReader;
import de.neemann.digital.core.memory.importer.LogisimReader;
import de.neemann.digital.core.memory.importer.ValueArray;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Importer.class);

    private Importer() {
    }

    public static DataField read(File hexFile, int dataBits, boolean bigEndian) throws IOException {
        DataField df = new DataField(1024);
        Importer.read(hexFile, new DataFieldValueArray(df, dataBits), bigEndian);
        return df;
    }

    public static void read(File file, ValueArray values, boolean bigEndian) throws IOException {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".hex")) {
            try {
                new LogisimReader(file).read(values);
            }
            catch (IOException e) {
                LOGGER.info(file + ": could not read native hex, try intel hex");
                new IntelHexReader(file).read(new ByteArrayFromValueArray(values, bigEndian));
            }
        } else {
            LOGGER.info(file + ": read as binary");
            new BinReader(file).read(new ByteArrayFromValueArray(values, bigEndian));
        }
    }
}

