/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.pld;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;

public class Diode
implements Element,
NodeInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Diode.class, new PinDescription[0]).addAttribute(Keys.ROTATE).addAttribute(Keys.BLOWN);
    private final ObservableValue cathode = new ObservableValue("cathode", 1).setToHighZ().setBidirectional();
    private final ObservableValue anode = new ObservableValue("anode", 1).setToHighZ().setBidirectional();
    private final boolean blown;
    private ObservableValue cathodeIn;
    private ObservableValue anodeIn;

    public Diode(ElementAttributes attr) {
        this.blown = attr.get(Keys.BLOWN);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.cathodeIn = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(1, null);
        this.anodeIn = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, null);
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.cathode, this.anode);
    }

    @Override
    public void registerNodes(Model model) {
    }

    @Override
    public void hasChanged() {
        if (!this.blown) {
            if (this.anodeIn.getBool() && !this.anodeIn.isHighZ()) {
                this.cathode.setValue(1L);
            } else {
                this.cathode.setToHighZ();
            }
            if (!this.cathodeIn.getBool() && !this.cathodeIn.isHighZ()) {
                this.anode.setValue(0L);
            } else {
                this.anode.setToHighZ();
            }
        }
    }

    @Override
    public void init(Model model) throws NodeException {
        this.hasChanged();
    }
}

