/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.stats;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class Statistics {
    private final TreeMap<Index, Counter> map;

    public Statistics(Model model) throws PinException {
        HashSet<CommonBusValue> cbvs = new HashSet<CommonBusValue>();
        this.map = new TreeMap();
        for (Node n : model) {
            if (n instanceof Countable) {
                this.count(new Index((Countable)((Object)n)));
            } else {
                this.count(new Index(n.getClass().getSimpleName()));
            }
            if (!(n instanceof Element)) continue;
            for (ObservableValue ov : ((Element)((Object)n)).getOutputs()) {
                for (Observer o : ov.getObservers()) {
                    if (!(o instanceof CommonBusValue)) continue;
                    cbvs.add((CommonBusValue)o);
                }
            }
        }
        for (CommonBusValue cbv : cbvs) {
            PinDescription.PullResistor r = cbv.getResistor();
            if (r != PinDescription.PullResistor.pullDown && r != PinDescription.PullResistor.pullUp) continue;
            this.count(new Index(r.name(), cbv.getBits()));
        }
    }

    private void count(Index i) {
        Counter counter = this.map.computeIfAbsent(i, index2 -> new Counter(i));
        counter.inc();
    }

    public TableModel getTableModel() {
        return new MyTableModel(new ArrayList<Counter>(this.map.values()));
    }

    private static final class Counter {
        private final Index index;
        private int counter;

        private Counter(Index index) {
            this.index = index;
            this.counter = 0;
        }

        private Index getIndex() {
            return this.index;
        }

        private int getCounter() {
            return this.counter;
        }

        private void inc() {
            ++this.counter;
        }
    }

    private static final class Index
    implements Comparable<Index> {
        private final String name;
        private final int bits;
        private final int inputs;
        private final int addrBits;

        private Index(String name, int bits) {
            this.name = name;
            this.bits = bits;
            this.inputs = 0;
            this.addrBits = 0;
        }

        private Index(String name) {
            this.name = name;
            this.bits = 0;
            this.inputs = 0;
            this.addrBits = 0;
        }

        private Index(Countable countable) {
            this.name = countable.getClass().getSimpleName();
            this.bits = countable.getDataBits();
            this.inputs = countable.getInputsCount();
            this.addrBits = countable.getAddrBits();
        }

        @Override
        public int compareTo(Index index) {
            int c = this.name.compareTo(index.name);
            if (c != 0) {
                return c;
            }
            c = this.inputs - index.inputs;
            if (c != 0) {
                return c;
            }
            c = this.bits - index.bits;
            if (c != 0) {
                return c;
            }
            return this.addrBits - index.addrBits;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            return this.bits == index.bits && this.inputs == index.inputs && this.addrBits == index.addrBits && this.name.equals(index.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.bits, this.inputs, this.addrBits);
        }
    }

    private static final class MyTableModel
    implements TableModel {
        private final ArrayList<Counter> counters;

        private MyTableModel(ArrayList<Counter> counters) {
            this.counters = counters;
        }

        @Override
        public int getRowCount() {
            return this.counters.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return Lang.get("stat_part", new Object[0]);
                }
                case 1: {
                    return Lang.get("stat_inputs", new Object[0]);
                }
                case 2: {
                    return Lang.get("stat_bits", new Object[0]);
                }
                case 3: {
                    return Lang.get("stat_addrBits", new Object[0]);
                }
            }
            return Lang.get("stat_number", new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int i) {
            if (i == 0) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Counter c = this.counters.get(row);
            switch (col) {
                case 0: {
                    return c.getIndex().name;
                }
                case 1: {
                    return this.checkNull(c.getIndex().inputs);
                }
                case 2: {
                    return this.checkNull(c.getIndex().bits);
                }
                case 3: {
                    return this.checkNull(c.getIndex().addrBits);
                }
            }
            return this.checkNull(c.getCounter());
        }

        private Object checkNull(int i) {
            if (i == 0) {
                return null;
            }
            return i;
        }

        @Override
        public void setValueAt(Object o, int i, int i1) {
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }
    }
}

