/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.switching;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.core.switching.PlainSwitch;
import de.neemann.digital.draw.elements.PinException;

public class NFET
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(NFET.class, PinInfo.input("G")).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.BITS).addAttribute(Keys.FET_UNIDIRECTIONAL).addAttribute(Keys.LABEL);
    private final PlainSwitch s;
    private ObservableValue input;
    private boolean closed;

    public NFET(ElementAttributes attr) {
        this(attr, false);
        this.s.getOutput1().setPinDescription(DESCRIPTION);
        this.s.getOutput2().setPinDescription(DESCRIPTION);
    }

    NFET(ElementAttributes attr, boolean pChan) {
        boolean uniDir = attr.get(Keys.FET_UNIDIRECTIONAL);
        if (pChan) {
            this.s = new PlainSwitch(attr.getBits(), false, "S", "D");
            if (uniDir) {
                this.s.setUnidirectional(PlainSwitch.Unidirectional.FROM1TO2);
            }
        } else {
            this.s = new PlainSwitch(attr.getBits(), false, "D", "S");
            if (uniDir) {
                this.s.setUnidirectional(PlainSwitch.Unidirectional.FROM2TO1);
            }
        }
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = ((ObservableValue)inputs.get(0)).checkBits(1, this, 0).addObserverToValue(this);
        this.s.setInputs((ObservableValue)inputs.get(1), (ObservableValue)inputs.get(2));
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return this.s.getOutputs();
    }

    @Override
    public void readInputs() throws NodeException {
        this.closed = this.getClosed(this.input);
    }

    boolean getClosed(ObservableValue input) {
        if (input.isHighZ()) {
            return false;
        }
        return input.getBool();
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.s.setClosed(this.closed);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void init(Model model) throws NodeException {
        this.s.init(model);
    }

    ObservableValue getOutput1() {
        return this.s.getOutput1();
    }

    ObservableValue getOutput2() {
        return this.s.getOutput2();
    }

    @Override
    public int getDataBits() {
        return this.s.getBits();
    }
}

