/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.switching;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.core.switching.PlainSwitchDT;

public class SwitchDT
implements Element,
NodeInterface,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(SwitchDT.class, new PinDescription[0]).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.POLES);
    private final PlainSwitchDT[] poles;
    private boolean closed;

    public SwitchDT(ElementAttributes attr) {
        int bits = attr.getBits();
        int poleCount = attr.get(Keys.POLES);
        this.poles = new PlainSwitchDT[poleCount];
        int i = 0;
        while (i < poleCount) {
            this.poles[i] = new PlainSwitchDT(bits, i + 1);
            ++i;
        }
    }

    @Override
    public ObservableValues getOutputs() {
        ObservableValues.Builder ov = new ObservableValues.Builder();
        PlainSwitchDT[] plainSwitchDTArray = this.poles;
        int n = this.poles.length;
        int n2 = 0;
        while (n2 < n) {
            PlainSwitchDT p = plainSwitchDTArray[n2];
            p.addOutputsTo(ov);
            ++n2;
        }
        return ov.build();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        int i = 0;
        PlainSwitchDT[] plainSwitchDTArray = this.poles;
        int n = this.poles.length;
        int n2 = 0;
        while (n2 < n) {
            PlainSwitchDT p = plainSwitchDTArray[n2];
            p.setInputs((ObservableValue)inputs.get(i), (ObservableValue)inputs.get(i + 1), (ObservableValue)inputs.get(i + 2));
            i += 3;
            ++n2;
        }
    }

    @Override
    public void init(Model model) {
        PlainSwitchDT[] plainSwitchDTArray = this.poles;
        int n = this.poles.length;
        int n2 = 0;
        while (n2 < n) {
            PlainSwitchDT p = plainSwitchDTArray[n2];
            p.init(model);
            ++n2;
        }
    }

    @Override
    public void hasChanged() {
        PlainSwitchDT[] plainSwitchDTArray = this.poles;
        int n = this.poles.length;
        int n2 = 0;
        while (n2 < n) {
            PlainSwitchDT p = plainSwitchDTArray[n2];
            p.hasChanged();
            ++n2;
        }
    }

    @Override
    public void registerNodes(Model model) {
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
        PlainSwitchDT[] plainSwitchDTArray = this.poles;
        int n = this.poles.length;
        int n2 = 0;
        while (n2 < n) {
            PlainSwitchDT p = plainSwitchDTArray[n2];
            p.setClosed(closed);
            ++n2;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getDataBits() {
        return this.poles[0].getBits();
    }

    @Override
    public int getInputsCount() {
        return this.poles.length;
    }
}

