/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.lang.Lang;

public class AsyncSeq
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(AsyncSeq.class, new PinDescription[0]).addAttribute(Keys.RUN_AT_REAL_TIME).addAttribute(Keys.FREQUENCY);
    private final int frequency;

    public AsyncSeq(ElementAttributes attributes) {
        if (attributes.get(Keys.RUN_AT_REAL_TIME).booleanValue()) {
            int f = attributes.get(Keys.FREQUENCY);
            if (f < 1) {
                f = 1;
            }
            this.frequency = f;
        } else {
            this.frequency = 0;
        }
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        throw new NodeException(Lang.get("err_noInputsAvailable", new Object[0]), new ObservableValue[0]);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void registerNodes(Model model) {
        model.setAsyncInfos(this);
    }

    public int getFrequency() {
        return this.frequency;
    }
}

