/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class BitSelector
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(BitSelector.class, PinInfo.input("in"), PinInfo.input("sel")).addAttribute(Keys.ROTATE).addAttribute(Keys.SELECTOR_BITS).addAttribute(Keys.FLIP_SEL_POSITON).supportsHDL();
    private final ObservableValue output;
    private final int selBits;
    private final int dataBits;
    private ObservableValue input;
    private ObservableValue selIn;
    private long value;
    private long sel;

    public BitSelector(ElementAttributes attributes) {
        this.selBits = attributes.get(Keys.SELECTOR_BITS);
        this.dataBits = 1 << this.selBits;
        this.output = new ObservableValue("out", 1).setPinDescription(DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        this.value = this.input.getValue();
        this.sel = this.selIn.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.output.setBool((this.value & 1L << (int)this.sel) != 0L);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.dataBits, this);
        this.selIn = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(this.selBits, this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }
}

