/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class Delay
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Delay.class, PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.DELAY_TIME);
    private final ObservableValue output;
    private final int bits;
    private final int delayTime;
    private ObservableValue input;
    private long[] value;
    private int pos;

    public Delay(ElementAttributes attributes) {
        this.bits = attributes.get(Keys.BITS);
        this.output = new ObservableValue("out", this.bits).setPinDescription(DESCRIPTION);
        int dt = attributes.get(Keys.DELAY_TIME);
        this.delayTime = dt < 1 ? 1 : dt;
        this.value = new long[this.delayTime];
    }

    @Override
    public void readInputs() throws NodeException {
        this.value[this.pos] = this.input.getValue();
        ++this.pos;
        if (this.pos >= this.delayTime) {
            this.pos = 0;
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.output.setValue(this.value[this.pos]);
        if (this.delayTime > 1) {
            boolean same = true;
            int i = 1;
            while (i < this.delayTime) {
                if (this.value[0] != this.value[i]) {
                    same = false;
                    break;
                }
                ++i;
            }
            if (!same) {
                this.hasChanged();
            }
        }
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }
}

