/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Collection;

public class Demultiplexer
extends Node
implements Element,
Countable {
    private final int selectorBits;
    private final Integer bits;
    private final long defaultValue;
    private final ObservableValues output;
    private ObservableValue selector;
    private ObservableValue input;
    private int oldSelectorValue;
    private int selectorValue;
    private long value;
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Demultiplexer.class, PinInfo.input("sel"), PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.SELECTOR_BITS).addAttribute(Keys.FLIP_SEL_POSITON).addAttribute(Keys.DEFAULT).supportsHDL();

    public Demultiplexer(ElementAttributes attributes) {
        this.bits = attributes.get(Keys.BITS);
        this.selectorBits = attributes.get(Keys.SELECTOR_BITS);
        this.defaultValue = attributes.get(Keys.DEFAULT);
        int outputs = 1 << this.selectorBits;
        ArrayList<ObservableValue> o = new ArrayList<ObservableValue>(outputs);
        int i = 0;
        while (i < outputs) {
            o.add(new ObservableValue("out_" + i, this.bits).setValue(this.defaultValue).setDescription(Lang.get("elem_Demultiplexer_output", i)));
            ++i;
        }
        this.output = new ObservableValues((Collection<ObservableValue>)o);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output;
    }

    @Override
    public void readInputs() throws NodeException {
        this.selectorValue = (int)this.selector.getValue();
        this.value = this.input.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        ((ObservableValue)this.output.get(this.oldSelectorValue)).setValue(this.defaultValue);
        ((ObservableValue)this.output.get(this.selectorValue)).setValue(this.value);
        this.oldSelectorValue = this.selectorValue;
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.selector = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.selectorBits, this);
        this.input = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(this.bits, this);
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getAddrBits() {
        return this.selectorBits;
    }
}

