/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeWithoutDelay;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.ImmutableList;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Splitter
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new SplitterTypeDescription().addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.INPUT_SPLIT).addAttribute(Keys.OUTPUT_SPLIT).addAttribute(Keys.SPLITTER_SPREADING).setShortName("").supportsHDL();
    private final ObservableValues outputs;
    private final Ports inPorts;
    private final Ports outPorts;
    private ObservableValues inputs;

    public static Splitter createOneToN(int bits) {
        Ports in = new Ports();
        in.add(new Port(0, bits));
        Ports out = new Ports();
        int i = 0;
        while (i < bits) {
            out.add(new Port(i, 1));
            ++i;
        }
        return new Splitter(in, out);
    }

    public static Splitter createNToOne(int bits) {
        Ports in = new Ports();
        int i = 0;
        while (i < bits) {
            in.add(new Port(i, 1));
            ++i;
        }
        Ports out = new Ports();
        out.add(new Port(0, bits));
        return new Splitter(in, out);
    }

    public Splitter(ElementAttributes attributes) throws BitsException {
        this(new Ports(attributes.get(Keys.INPUT_SPLIT)), new Ports(attributes.get(Keys.OUTPUT_SPLIT)));
    }

    private Splitter(Ports inPorts, Ports outPorts) {
        this.inPorts = inPorts;
        this.outPorts = outPorts;
        this.outputs = outPorts.getOutputs();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.inputs = inputs;
        this.inPorts.checkInputConsistency();
        if (this.inPorts.getBits() < this.outPorts.getBits()) {
            throw new BitsException(Lang.get("err_splitterBitsMismatch", new Object[0]), ImmutableList.combine(inputs, this.outputs));
        }
        int i = 0;
        while (i < inputs.size()) {
            Port inPort = this.inPorts.getPort(i);
            if (inPort.getBits() != ((ObservableValue)inputs.get(i)).getBits()) {
                throw new BitsException(Lang.get("err_splitterBitsMismatch", new Object[0]), inputs);
            }
            ++i;
        }
        for (Port out : this.outPorts) {
            this.fillOutput(out);
        }
    }

    private void fillOutput(Port out) throws NodeException {
        for (Port in : this.inPorts) {
            ObservableValue outValue;
            ObservableValue inValue;
            int bitsToCopy;
            int bitPos;
            if (in.getPos() + in.getBits() <= out.getPos() || out.getPos() + out.getBits() <= in.getPos()) continue;
            if (out.getPos() >= in.getPos() && out.getPos() + out.getBits() <= in.getPos() + in.getBits()) {
                bitPos = out.getPos() - in.getPos();
                final ObservableValue inValue2 = (ObservableValue)this.inputs.get(in.number);
                final ObservableValue outValue2 = (ObservableValue)this.outputs.get(out.number);
                inValue2.addObserverToValue(new NodeWithoutDelay(new ObservableValue[]{outValue2}){

                    @Override
                    public void hasChanged() {
                        outValue2.set(inValue2.getValue() >>> bitPos, inValue2.getHighZ() >>> bitPos);
                    }
                });
                break;
            }
            if (out.getPos() <= in.getPos() && in.getPos() + in.getBits() <= out.getPos() + out.getBits()) {
                bitPos = in.getPos() - out.getPos();
                final long mask = Bits.up(Bits.mask(in.bits), bitPos) ^ 0xFFFFFFFFFFFFFFFFL;
                final ObservableValue inValue3 = (ObservableValue)this.inputs.get(in.number);
                final ObservableValue outValue3 = (ObservableValue)this.outputs.get(out.number);
                ((ObservableValue)this.inputs.get(in.number)).addObserverToValue(new NodeWithoutDelay(new ObservableValue[]{outValue3}){

                    @Override
                    public void hasChanged() {
                        long in1 = inValue3.getValue();
                        long out1 = outValue3.getValue();
                        long inz1 = inValue3.getHighZ();
                        long outz1 = outValue3.getHighZ();
                        outValue3.set(out1 & mask | in1 << bitPos, outz1 & mask | inz1 << bitPos);
                    }
                });
                continue;
            }
            if (in.getPos() < out.getPos()) {
                bitsToCopy = in.getPos() + in.getBits() - out.getPos();
                final long mask = Bits.mask(bitsToCopy) ^ 0xFFFFFFFFFFFFFFFFL;
                final int shift = out.getPos() - in.getPos();
                inValue = (ObservableValue)this.inputs.get(in.number);
                outValue = (ObservableValue)this.outputs.get(out.number);
                ((ObservableValue)this.inputs.get(in.number)).addObserverToValue(new NodeWithoutDelay(new ObservableValue[]{outValue}){

                    @Override
                    public void hasChanged() {
                        long in12 = inValue.getValue();
                        long out12 = outValue.getValue();
                        long inz12 = inValue.getHighZ();
                        long outz12 = outValue.getHighZ();
                        outValue.set(out12 & mask | in12 >>> shift, outz12 & mask | inz12 >>> shift);
                    }
                });
                continue;
            }
            bitsToCopy = out.getPos() + out.getBits() - in.getPos();
            final int shift = in.getPos() - out.getPos();
            final long mask = Bits.up(Bits.mask(bitsToCopy), shift) ^ 0xFFFFFFFFFFFFFFFFL;
            inValue = (ObservableValue)this.inputs.get(in.number);
            outValue = (ObservableValue)this.outputs.get(out.number);
            ((ObservableValue)this.inputs.get(in.number)).addObserverToValue(new NodeWithoutDelay(new ObservableValue[]{outValue}){

                @Override
                public void hasChanged() {
                    long in13 = inValue.getValue();
                    long out13 = outValue.getValue();
                    long inz13 = inValue.getHighZ();
                    long outz13 = outValue.getHighZ();
                    outValue.set(out13 & mask | in13 << shift, outz13 & mask | inz13 << shift);
                }
            });
        }
    }

    @Override
    public ObservableValues getOutputs() {
        return this.outputs;
    }

    @Override
    public void registerNodes(Model model) {
    }

    @Override
    public void init(Model m) {
        for (ObservableValue v : this.inputs) {
            v.fireHasChanged();
        }
    }

    public static final class Port {
        private final int bits;
        private final int pos;
        private final String name;
        private int number;

        private Port(int pos, int bits) {
            this.pos = pos;
            this.bits = bits;
            this.name = bits == 1 ? "" + pos : (bits == 2 ? pos + "," + (pos + 1) : pos + "-" + (pos + bits - 1));
        }

        public int getBits() {
            return this.bits;
        }

        public int getPos() {
            return this.pos;
        }

        public String getName() {
            return this.name;
        }

        private void setNumber(int number) {
            this.number = number;
        }
    }

    public static final class Ports
    implements Iterable<Port> {
        private final ArrayList<Port> ports = new ArrayList();
        private int bits = 0;

        Ports() {
        }

        public Ports(String definition) throws BitsException {
            this();
            StringTokenizer st = new StringTokenizer(definition, ",", false);
            while (st.hasMoreTokens()) {
                try {
                    String strVal = st.nextToken().trim();
                    int pos = strVal.indexOf(42);
                    if (pos >= 0) {
                        int b = Integer.decode(strVal.substring(0, pos).trim());
                        int count = Integer.decode(strVal.substring(pos + 1).trim());
                        int i = 0;
                        while (i < count) {
                            this.add(new Port(this.bits, b));
                            ++i;
                        }
                        continue;
                    }
                    pos = strVal.indexOf(45);
                    if (pos >= 0) {
                        int from = Integer.decode(strVal.substring(0, pos).trim());
                        int to = Integer.decode(strVal.substring(pos + 1).trim());
                        if (to < from) {
                            int z = to;
                            to = from;
                            from = z;
                        }
                        this.add(new Port(from, to - from + 1));
                        continue;
                    }
                    this.add(new Port(this.bits, Integer.decode(strVal)));
                }
                catch (RuntimeException e) {
                    throw new BitsException(Lang.get("err_spitterDefSyntaxError", definition));
                }
            }
            if (this.ports.isEmpty()) {
                this.add(new Port(this.bits, 1));
            }
            if (this.bits > 64) {
                throw new BitsException(Lang.get("err_spitterToManyBits", definition));
            }
        }

        void checkInputConsistency() throws BitsException {
            long fullMask = Bits.mask(this.bits);
            for (Port p : this.ports) {
                long mask = Bits.up(Bits.mask(p.bits), p.pos);
                if ((fullMask & mask) != mask) {
                    throw new BitsException(Lang.get("err_splitterNotUnambiguously", new Object[0]));
                }
                fullMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (fullMask != 0L) {
                throw new BitsException(Lang.get("err_splitterNotAllBitsDefined", new Object[0]));
            }
        }

        private void add(Port port) {
            port.setNumber(this.ports.size());
            this.ports.add(port);
            int b = port.pos + port.bits;
            if (b > this.bits) {
                this.bits = b;
            }
        }

        public int getBits() {
            return this.bits;
        }

        private PinDescriptions getNames(PinDescription.Direction dir) {
            PinDescription[] name = new PinInfo[this.ports.size()];
            int i = 0;
            while (i < name.length) {
                Port port = this.ports.get(i);
                name[i] = port.getBits() == 1 ? new PinInfo(port.getName(), Lang.get("elem_Splitter_pin_in_one", port.getName()), dir) : new PinInfo(port.getName(), Lang.get("elem_Splitter_pin_in", port.getName()), dir);
                ++i;
            }
            return new PinDescriptions(name);
        }

        ObservableValues getOutputs() {
            ArrayList<ObservableValue> outputs = new ArrayList<ObservableValue>(this.ports.size());
            for (Port p : this.ports) {
                if (p.getBits() == 1) {
                    outputs.add(new ObservableValue(p.getName(), p.getBits()).setDescription(Lang.get("elem_Splitter_pin_out_one", p.getName())));
                    continue;
                }
                outputs.add(new ObservableValue(p.getName(), p.getBits()).setDescription(Lang.get("elem_Splitter_pin_out", p.getName())));
            }
            return new ObservableValues((Collection<ObservableValue>)outputs);
        }

        public Port getPort(int i) {
            return this.ports.get(i);
        }

        @Override
        public Iterator<Port> iterator() {
            return this.ports.iterator();
        }
    }

    private static class SplitterTypeDescription
    extends ElementTypeDescription {
        SplitterTypeDescription() {
            super(Splitter.class, new PinDescription[0]);
        }

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) throws BitsException {
            Ports p = new Ports(elementAttributes.get(Keys.INPUT_SPLIT));
            return p.getNames(PinDescription.Direction.input);
        }
    }
}

