/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring.bus;

import de.neemann.digital.core.BurnException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.wiring.bus.BusModelStateObserver;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractBusHandler {
    private final BusModelStateObserver obs;
    private HashSet<File> origin;
    private State burn;
    private int addedVersion = -1;

    AbstractBusHandler(BusModelStateObserver obs) {
        this.obs = obs;
    }

    public abstract List<ObservableValue> getInputs();

    public abstract PinDescription.PullResistor getResistor();

    public abstract void set(long var1, long var3);

    public abstract ObservableValues getAllValues();

    void recalculate() {
        long value = 0L;
        this.burn = State.ok;
        if (this.getResistor().equals((Object)PinDescription.PullResistor.both)) {
            this.burn = State.both;
            this.set(0L, -1L);
        } else {
            long highz = -1L;
            for (ObservableValue input : this.getInputs()) {
                highz &= input.getHighZ();
                value |= input.getValueHighZIsZero();
            }
            for (ObservableValue input : this.getInputs()) {
                long bothDefine = (highz | input.getHighZ()) ^ 0xFFFFFFFFFFFFFFFFL;
                if ((value & bothDefine) == (input.getValueHighZIsZero() & bothDefine)) continue;
                this.burn = State.burn;
                break;
            }
            switch (this.getResistor()) {
                case pullUp: {
                    this.set(value | highz, 0L);
                    break;
                }
                case pullDown: {
                    this.set(value, 0L);
                    break;
                }
                default: {
                    this.set(value, highz);
                }
            }
        }
        if (this.burn != State.ok && this.obs.getVersion() != this.addedVersion) {
            this.addedVersion = this.obs.getVersion();
            this.obs.addCheck(this);
        }
    }

    void checkBurn() {
        switch (this.burn) {
            case burn: {
                throw new BurnException(Lang.get("err_burnError", new Object[0]), this.getAllValues()).addOrigin(this.origin);
            }
            case both: {
                throw new BurnException(Lang.get("err_pullUpAndDown", new Object[0]), this.getAllValues()).addOrigin(this.origin);
            }
        }
    }

    AbstractBusHandler addOrigin(File file) {
        if (this.origin == null) {
            this.origin = new HashSet();
        }
        this.origin.add(file);
        return this;
    }

    private static enum State {
        ok,
        burn,
        both;

    }
}

