/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring.bus;

import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.wiring.bus.AbstractBusHandler;
import de.neemann.digital.core.wiring.bus.BusModelStateObserver;
import de.neemann.digital.core.wiring.bus.SingleBusHandler;
import de.neemann.digital.draw.elements.PinException;
import java.io.File;
import java.util.Arrays;

public final class CommonBusValue
extends ObservableValue
implements NodeInterface {
    private final BusModelStateObserver obs;
    private final PinDescription.PullResistor resistor;
    private final ObservableValue[] inputs;
    private final File origin;
    private AbstractBusHandler handler;

    CommonBusValue(int bits, BusModelStateObserver obs, PinDescription.PullResistor resistor, ObservableValue[] inputs) {
        this(bits, obs, resistor, inputs, null);
    }

    CommonBusValue(int bits, BusModelStateObserver obs, PinDescription.PullResistor resistor, ObservableValue[] inputs, File origin) {
        super("commonBusOut", bits);
        if (resistor.equals((Object)PinDescription.PullResistor.none)) {
            this.setToHighZ();
        }
        this.obs = obs;
        this.resistor = resistor;
        this.inputs = inputs;
        this.origin = origin;
        this.resetHandler();
    }

    @Override
    public void hasChanged() {
        this.handler.recalculate();
    }

    void setHandler(AbstractBusHandler handler) {
        this.handler = handler;
    }

    void resetHandler() {
        this.setHandler(new SingleBusHandler(this.obs, this, this.resistor, this.inputs).addOrigin(this.origin));
        this.hasChanged();
    }

    public PinDescription.PullResistor getResistor() {
        return this.resistor;
    }

    public ObservableValue[] getInputs() {
        return this.inputs;
    }

    public ObservableValue searchConstant() {
        ObservableValue[] observableValueArray = this.inputs;
        int n = this.inputs.length;
        int n2 = 0;
        while (n2 < n) {
            ObservableValue i = observableValueArray[n2];
            if (i.isConstant()) {
                return i;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String toString() {
        return "CommonBusValue{inputs=" + Arrays.toString(this.inputs) + "', -->" + super.toString() + " }";
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return new ObservableValues(new ObservableValue[]{this});
    }

    public File getOrigin() {
        return this.origin;
    }
}

