/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.ElementOrderer;
import de.neemann.digital.undo.Modification;
import de.neemann.digital.undo.Modifications;
import java.util.ArrayList;

public class ElementOrder
implements ElementOrderer.OrderInterface<String> {
    private final ArrayList<Entry> entries;
    private final Modifications.Builder<Circuit> modifications;
    private final String modificationName;

    public ElementOrder(CircuitComponent circuitComponent, ElementFilter filter, String modificationName) {
        this.modificationName = modificationName;
        ArrayList<VisualElement> elements = circuitComponent.getCircuit().getElements();
        this.entries = new ArrayList();
        int i = 0;
        while (i < elements.size()) {
            String n;
            if (filter.accept(elements.get(i)) && (n = elements.get(i).getElementAttributes().getLabel()) != null && n.length() > 0) {
                this.entries.add(new Entry(i, n));
            }
            ++i;
        }
        this.modifications = new Modifications.Builder(modificationName);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public String get(int index) {
        return this.entries.get(index).name;
    }

    @Override
    public void swap(int i, int j) {
        int index1 = this.entries.get(i).i;
        int index2 = this.entries.get(j).i;
        int z = this.entries.get(i).i;
        this.entries.get(i).i = this.entries.get(j).i;
        this.entries.get(j).i = z;
        Entry x = this.entries.get(i);
        this.entries.set(i, this.entries.get(j));
        this.entries.set(j, x);
        this.modifications.add(new SwapModification(index1, index2, this.modificationName));
    }

    public Modification<Circuit> getModifications() {
        return this.modifications.build();
    }

    public static interface ElementFilter {
        public boolean accept(VisualElement var1);
    }

    private static final class Entry {
        private int i;
        private final String name;

        private Entry(int i, String name) {
            this.i = i;
            this.name = name;
        }
    }

    private static final class SwapModification
    implements Modification<Circuit> {
        private final int index1;
        private final int index2;
        private final String name;

        private SwapModification(int index1, int index2, String name) {
            this.index1 = index1;
            this.index2 = index2;
            this.name = name;
        }

        @Override
        public void modify(Circuit circuit) {
            ArrayList<VisualElement> elements = circuit.getElements();
            VisualElement y = elements.get(this.index1);
            elements.set(this.index1, elements.get(this.index2));
            elements.set(this.index2, y);
        }

        public String toString() {
            return this.name;
        }
    }
}

