/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.gui.Settings;
import java.awt.Color;
import java.util.Arrays;

public final class ColorScheme {
    private static final ColorScheme DEFAULT_SCHEME = new Builder().set(ColorKey.BACKGROUND, Color.WHITE).set(ColorKey.MAIN, Color.BLACK).set(ColorKey.WIRE, Color.BLUE.darker()).set(ColorKey.WIRE_LOW, new Color(0, 142, 0)).set(ColorKey.WIRE_HIGH, new Color(102, 255, 102)).set(ColorKey.WIRE_OUT, Color.RED.darker()).set(ColorKey.WIRE_VALUE, new Color(50, 162, 50)).set(ColorKey.WIRE_Z, Color.GRAY).set(ColorKey.PINS, Color.GRAY).set(ColorKey.HIGHLIGHT, Color.CYAN).set(ColorKey.GRID, new Color(210, 210, 210)).set(ColorKey.PASSED, Color.GREEN).set(ColorKey.ERROR, Color.RED).set(ColorKey.DISABLED, Color.LIGHT_GRAY).set(ColorKey.TESTCASE, new Color(180, 255, 180, 200)).set(ColorKey.ASYNC, new Color(255, 180, 180, 200)).build();
    private static final ColorScheme DARK_SCHEME = new Builder(DEFAULT_SCHEME).set(ColorKey.BACKGROUND, Color.BLACK).set(ColorKey.MAIN, Color.GRAY).set(ColorKey.GRID, new Color(50, 50, 50)).set(ColorKey.DISABLED, new Color(40, 40, 40)).build();
    private static final ColorScheme COLOR_BLIND_SCHEME = new Builder(DEFAULT_SCHEME).set(ColorKey.WIRE, new Color(0, 0, 255)).set(ColorKey.WIRE_HIGH, new Color(98, 255, 41)).set(ColorKey.WIRE_LOW, new Color(0, 52, 0)).set(ColorKey.WIRE_OUT, new Color(250, 165, 0)).set(ColorKey.HIGHLIGHT, new Color(255, 255, 0)).build();
    public static final Key<ColorSchemes> COLOR_SCHEME = new Key.KeyEnum("colorScheme", (Enum)ColorSchemes.DEFAULT, (Enum[])ColorSchemes.values()).setRequiresRepaint();
    public static final Key<ColorScheme> CUSTOM_COLOR_SCHEME = new Key<ColorScheme>("customColorScheme", DEFAULT_SCHEME).setDependsOn(COLOR_SCHEME, o -> o.equals((Object)ColorSchemes.CUSTOM)).setRequiresRepaint();
    private static ColorScheme instance = null;
    private final Color[] colors;

    public static void updateCustomColorScheme(ElementAttributes modified) {
        ColorSchemes.CUSTOM.set(modified.get(ColorScheme.CUSTOM_COLOR_SCHEME));
    }

    public static ColorScheme getSelected() {
        if (instance == null) {
            ColorScheme.updateInstance();
            Settings.getInstance().getAttributes().addListener(ColorScheme::updateInstance);
        }
        return instance;
    }

    private static void updateInstance() {
        instance = Settings.getInstance().get(COLOR_SCHEME).getScheme();
    }

    private ColorScheme(Builder builder) {
        this.colors = builder.colors;
    }

    public Color getColor(ColorKey key) {
        return this.colors[key.ordinal()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorScheme that = (ColorScheme)o;
        return Arrays.equals(this.colors, that.colors);
    }

    public int hashCode() {
        return Arrays.hashCode(this.colors);
    }

    static /* synthetic */ ColorScheme access$1() {
        return DARK_SCHEME;
    }

    static /* synthetic */ ColorScheme access$2() {
        return COLOR_BLIND_SCHEME;
    }

    /* synthetic */ ColorScheme(Builder builder, ColorScheme colorScheme) {
        this(builder);
    }

    public static final class Builder {
        private final Color[] colors;

        private Builder() {
            this.colors = new Color[ColorKey.values().length];
        }

        public Builder(ColorScheme colorScheme) {
            this.colors = (Color[])colorScheme.colors.clone();
        }

        public Builder set(ColorKey key, Color color) {
            this.colors[key.ordinal()] = color;
            return this;
        }

        public Builder set(ColorScheme colorScheme) {
            ColorKey[] colorKeyArray = ColorKey.values();
            int n = colorKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorKey ck = colorKeyArray[n2];
                this.colors[ck.ordinal()] = colorScheme.getColor(ck);
                ++n2;
            }
            return this;
        }

        public ColorScheme build() {
            return new ColorScheme(this, null);
        }

        public Color getColor(ColorKey key) {
            return this.colors[key.ordinal()];
        }
    }

    public static enum ColorSchemes {
        DEFAULT(ColorScheme.access$0()),
        DARK(ColorScheme.access$1()),
        COLOR_BLIND(ColorScheme.access$2()),
        CUSTOM(null);

        private ColorScheme scheme;

        private ColorSchemes(ColorScheme scheme) {
            this.scheme = scheme;
        }

        public ColorScheme getScheme() {
            if (this.scheme == null) {
                this.scheme = Settings.getInstance().get(CUSTOM_COLOR_SCHEME);
            }
            return this.scheme;
        }

        private static void printScheme(ColorScheme scheme) {
            System.out.println("private static final ColorScheme COLOR_BLIND_SCHEME = new Builder(DEFAULT_SCHEME)");
            ColorKey[] colorKeyArray = ColorKey.values();
            int n = colorKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorKey ck = colorKeyArray[n2];
                Color c = scheme.getColor(ck);
                if (!DEFAULT_SCHEME.getColor(ck).equals(c)) {
                    if (c.getAlpha() == 255) {
                        System.out.println(".set(ColorKey." + ck.name() + ", new Color(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + "))");
                    } else {
                        System.out.println(".set(ColorKey." + ck.name() + ", new Color(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + "))");
                    }
                }
                ++n2;
            }
            System.out.println(".build();");
        }

        private void set(ColorScheme newScheme) {
            if (this.scheme != null && !this.scheme.equals(newScheme)) {
                this.scheme = newScheme;
                if (Settings.getInstance().get(COLOR_SCHEME).equals((Object)CUSTOM)) {
                    instance = newScheme;
                }
            }
        }
    }
}

