/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import java.io.Closeable;
import java.io.IOException;

public abstract class Graphic
implements Closeable {
    public Graphic setBoundingBox(VectorInterface min, VectorInterface max) {
        return this;
    }

    public abstract void drawLine(VectorInterface var1, VectorInterface var2, Style var3);

    public abstract void drawPolygon(Polygon var1, Style var2);

    public abstract void drawCircle(VectorInterface var1, VectorInterface var2, Style var3);

    public void drawCircleHighlight(VectorInterface p1, VectorInterface p2, Style style) {
        this.drawCircle(p1, p2, style);
    }

    public abstract void drawText(VectorInterface var1, VectorInterface var2, VectorInterface var3, String var4, Orientation var5, Style var6);

    public final void drawText(VectorInterface p1, VectorInterface p2, String text, Orientation orientation, Style style) {
        VectorFloat d = p2.sub(p1).toFloat().getOrthogonal();
        this.drawText(p1, p2, p1.add(d), text, orientation, style);
    }

    public final void drawText(VectorInterface pos, String text, Orientation orientation, Style style) {
        this.drawText(pos, pos.add(new Vector(1, 0)), text, orientation, style);
    }

    public void openGroup() {
    }

    public void closeGroup() {
    }

    public boolean isFlagSet(Flag flag) {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public static enum Flag {
        noShapeFilling,
        smallIO,
        hideTest,
        noPinMarker,
        thinnerLines,
        tiny;

    }
}

