/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.draw.graphics.text.formatter.GraphicsFormatter;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class GraphicSwing
extends Graphic {
    private final int minFontSize;
    private final int pixelSize;
    private final Style highlightSmall;
    private Style lastStyle;
    private Graphics2D gr;

    public GraphicSwing(Graphics2D gr) {
        this(gr, 1);
    }

    public GraphicSwing(Graphics2D gr, int pixelSize) {
        this.gr = gr;
        this.pixelSize = pixelSize;
        this.minFontSize = pixelSize * 3;
        this.highlightSmall = Style.HIGHLIGHT.deriveStyle(pixelSize * 3, false, Style.HIGHLIGHT.getColor());
    }

    protected void setGraphics2D(Graphics2D gr) {
        this.gr = gr;
    }

    public void enableAntiAlias(boolean antiAlias) {
        if (antiAlias) {
            this.gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.gr.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            this.gr.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            this.gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.gr.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this.gr.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
    }

    @Override
    public void drawLine(VectorInterface p1, VectorInterface p2, Style style) {
        this.applyStyle(style);
        this.gr.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    @Override
    public void drawPolygon(Polygon p, Style style) {
        this.applyStyle(style);
        GeneralPath path = new GeneralPath();
        p.drawTo(path);
        if (style.isFilled() && p.isClosed()) {
            this.gr.fill(path);
        }
        if (style.getThickness() > 0) {
            this.gr.draw(path);
        }
    }

    @Override
    public void drawCircle(VectorInterface p1, VectorInterface p2, Style style) {
        Vector w = Vector.width(p1, p2);
        if (w.x > this.pixelSize || w.y > this.pixelSize) {
            this.applyStyle(style);
            Vector p = Vector.min(p1, p2);
            if (style.isFilled()) {
                this.gr.fillOval(p.x - 1, p.y - 1, w.x + 2, w.y + 2);
            } else {
                this.gr.drawOval(p.x, p.y, w.x, w.y);
            }
        }
    }

    @Override
    public void drawCircleHighlight(VectorInterface p1, VectorInterface p2, Style style) {
        if (style.getThickness() < this.highlightSmall.getThickness()) {
            if (style == Style.HIGHLIGHT) {
                this.applyStyle(this.highlightSmall);
            } else {
                this.applyStyle(style);
                this.gr.setStroke(this.highlightSmall.getStroke());
                this.lastStyle = null;
            }
        } else {
            this.applyStyle(style);
        }
        Vector w = Vector.width(p1, p2);
        Vector p = Vector.min(p1, p2);
        int minSize = this.pixelSize * 8;
        if (w.x < minSize || w.y < minSize) {
            VectorInterface c = p1.add(p2).div(2);
            w = new Vector(Math.max(minSize, w.x), Math.max(minSize, w.y));
            p = c.sub(w.div(2)).round();
        }
        this.gr.drawOval(p.x, p.y, w.x, w.y);
    }

    private void applyStyle(Style style) {
        if (style != this.lastStyle) {
            this.gr.setStroke(style.getStroke());
            this.gr.setColor(style.getColor());
            this.gr.setFont(style.getFont());
            this.lastStyle = style;
        }
    }

    @Override
    public void drawText(VectorInterface p1, VectorInterface p2, VectorInterface p3, String text, Orientation orientation, Style style) {
        this.applyStyle(style);
        int fontHeight = this.gr.getFontMetrics().getHeight();
        if (fontHeight > this.minFontSize) {
            if (text == null || text.length() == 0) {
                return;
            }
            boolean rotateText = false;
            if (p1.getY() == p2.getY()) {
                if (p1.getX() > p2.getX()) {
                    orientation = orientation.rot(2);
                }
            } else {
                orientation = p1.getY() < p2.getY() ? orientation.rot(2) : orientation.rot(0);
                rotateText = true;
            }
            GraphicsFormatter.Fragment fragment = GraphicsFormatter.createFragment(this.gr, text);
            AffineTransform old = null;
            if (rotateText) {
                old = this.gr.getTransform();
                this.gr.translate(p1.getXFloat(), p1.getYFloat());
                this.gr.rotate(-1.5707963267948966);
                this.gr.translate(-p1.getXFloat(), -p1.getYFloat());
            }
            int xoff = 0;
            if (orientation.getX() != 0) {
                int width = fragment.getWidth();
                xoff -= width * orientation.getX() / 2;
            }
            int yoff = 0;
            int oy = GraphicSwing.getMirrorYOrientation(orientation, p1, p2, p3);
            if (oy != 0) {
                int height = fragment.getHeight();
                yoff += height * oy / 3;
            }
            fragment.draw(this.gr, p1.getX() + xoff, p1.getY() + yoff);
            if (rotateText) {
                this.gr.setTransform(old);
            }
        }
    }

    static int getMirrorYOrientation(Orientation orientation, VectorInterface p1, VectorInterface p2, VectorInterface p3) {
        VectorInterface d1;
        int oy = orientation.getY();
        VectorInterface d0 = p2.sub(p1).getOrthogonal();
        if (d0.scalar(d1 = p3.sub(p1)) < 0.0f) {
            oy = 2 - oy;
        }
        return oy;
    }

    @Override
    public boolean isFlagSet(Graphic.Flag flag) {
        if (flag == Graphic.Flag.tiny) {
            return this.pixelSize > 3;
        }
        return false;
    }
}

