/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.VectorInterface;

public class GraphicTransform
extends Graphic {
    private final Graphic parent;
    private final Transform transform;

    public GraphicTransform(Graphic parent, Transform transform) {
        this.parent = parent;
        this.transform = transform;
    }

    @Override
    public void drawLine(VectorInterface p1, VectorInterface p2, Style style) {
        this.parent.drawLine(p1.transform(this.transform), p2.transform(this.transform), style);
    }

    @Override
    public void drawPolygon(Polygon p, Style style) {
        this.parent.drawPolygon(p.transform(this.transform), style);
    }

    @Override
    public void drawCircle(VectorInterface p1, VectorInterface p2, Style style) {
        this.parent.drawCircle(p1.transform(this.transform), p2.transform(this.transform), style);
    }

    @Override
    public void drawText(VectorInterface p1, VectorInterface p2, VectorInterface p3, String text, Orientation orientation, Style style) {
        this.parent.drawText(p1.transform(this.transform), p2.transform(this.transform), p3.transform(this.transform), text, orientation, style);
    }

    @Override
    public boolean isFlagSet(Graphic.Flag flag) {
        return this.parent.isFlagSet(flag);
    }
}

