/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.PolygonParser;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Iterator;

public class Polygon
implements Iterable<PathElement> {
    private final ArrayList<PathElement> path;
    private boolean closed;
    private boolean hasSpecialElements = false;
    private boolean evenOdd;

    public Polygon() {
        this(new ArrayList<VectorInterface>(), true);
    }

    public Polygon(boolean closed) {
        this(new ArrayList<VectorInterface>(), closed);
    }

    public Polygon(ArrayList<VectorInterface> points, boolean closed) {
        this.closed = closed;
        this.path = new ArrayList();
        for (VectorInterface p : points) {
            this.add(p);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Polygon add(int x, int y) {
        return this.add(new Vector(x, y));
    }

    public Polygon add(VectorInterface p) {
        if (this.path.isEmpty()) {
            this.add(new MoveTo(p));
        } else {
            this.add(new LineTo(p, null, null));
        }
        return this;
    }

    private void add(PathElement pe) {
        this.path.add(pe);
    }

    public Polygon add(VectorInterface c1, VectorInterface c2, VectorInterface p) {
        if (this.path.size() == 0) {
            throw new RuntimeException("cubic bezier curve is not allowed to be the first path element");
        }
        this.add(new CurveTo(c1, c2, p));
        this.hasSpecialElements = true;
        return this;
    }

    public Polygon add(VectorInterface c, VectorInterface p) {
        if (this.path.size() == 0) {
            throw new RuntimeException("quadratic bezier curve is not allowed to be the first path element");
        }
        this.add(new QuadTo(c, p));
        this.hasSpecialElements = true;
        return this;
    }

    public void addClosePath() {
        this.add(new ClosePath());
    }

    public void addMoveTo(VectorFloat p) {
        this.add(new MoveTo((VectorInterface)p));
    }

    public boolean getEvenOdd() {
        return this.evenOdd;
    }

    public Polygon setEvenOdd(boolean evenOdd) {
        this.evenOdd = evenOdd;
        return this;
    }

    public boolean addLine(VectorInterface p1, VectorInterface p2) {
        return this.check(p1, p2) || this.check(p2, p1);
    }

    private boolean check(VectorInterface p1, VectorInterface p2) {
        if (this.closed) {
            return false;
        }
        if (p1.equals(this.getFirst())) {
            if (p2.equals(this.getLast())) {
                this.closed = true;
            } else {
                this.removeInitialMoveTo();
                this.path.add(0, new MoveTo(p2));
            }
            return true;
        }
        if (p1.equals(this.getLast())) {
            if (p2.equals(this.getFirst())) {
                this.closed = true;
            } else {
                this.path.add(new LineTo(p2, null, null));
            }
            return true;
        }
        return false;
    }

    private void removeInitialMoveTo() {
        if (!(this.path.get(0) instanceof MoveTo)) {
            throw new RuntimeException("initial path element is not a MoveTo!");
        }
        this.path.set(0, new LineTo(this.path.get(0)));
    }

    public VectorInterface getFirst() {
        return this.path.get(0).getPoint();
    }

    public VectorInterface getLast() {
        return this.path.get(this.path.size() - 1).getPoint();
    }

    public Polygon append(Polygon p2) {
        if (this.hasSpecialElements || p2.hasSpecialElements) {
            throw new RuntimeException("append of bezier not supported");
        }
        if (p2.getLast().equals(this.getFirst())) {
            int i = 1;
            while (i < p2.path.size() - 1) {
                this.add(p2.path.get(i).getPoint());
                ++i;
            }
            this.closed = true;
        } else {
            int i = 1;
            while (i < p2.path.size()) {
                this.add(p2.path.get(i).getPoint());
                ++i;
            }
        }
        return this;
    }

    public Polygon reverse() {
        if (this.hasSpecialElements) {
            throw new RuntimeException("append of bezier not supported");
        }
        Polygon p = new Polygon(this.closed);
        int i = this.path.size() - 1;
        while (i >= 0) {
            p.add(this.path.get(i).getPoint());
            --i;
        }
        return p;
    }

    public Polygon transform(Transform transform) {
        if (transform == Transform.IDENTITY) {
            return this;
        }
        Polygon p = new Polygon(this.closed).setEvenOdd(this.evenOdd);
        for (PathElement pe : this.path) {
            p.add(pe.transform(transform));
        }
        return p;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PathElement pe : this.path) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(pe.toString());
        }
        if (this.closed) {
            sb.append(" Z");
        }
        return sb.toString();
    }

    public static Polygon createFromPath(String path) {
        try {
            return new PolygonParser(path).create();
        }
        catch (PolygonParser.ParserException e) {
            return null;
        }
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public Iterator<PathElement> iterator() {
        return this.path.iterator();
    }

    public void drawTo(Path2D path2d) {
        for (PathElement pe : this.path) {
            pe.drawTo(path2d);
        }
        if (this.closed) {
            path2d.closePath();
        }
        if (this.evenOdd) {
            path2d.setWindingRule(0);
        }
    }

    public void traverse(PointVisitor v) {
        VectorInterface start = null;
        for (PathElement pe : this.path) {
            start = pe.traverse(start, v);
        }
    }

    public Polygon roundEdges(int rad) {
        Polygon newPoly = new Polygon(this.closed);
        int len = this.path.size();
        if (!this.closed) {
            --len;
        }
        int i = 0;
        while (i < len) {
            VectorInterface p0 = this.path.get(i).getPoint();
            VectorInterface p1 = this.path.get(this.wrapIndex(i + 1)).getPoint();
            VectorInterface p2 = this.path.get(this.wrapIndex(i + 2)).getPoint();
            VectorInterface d0 = p1.sub(p0);
            float l0 = d0.len();
            VectorInterface d1 = p2.sub(p1);
            float l1 = d1.len();
            VectorInterface n0 = p0.add(d0.mul((float)rad / l0));
            VectorInterface n1 = p0.add(d0.mul((l0 - (float)rad) / l0));
            VectorInterface n2 = p1.add(d1.mul((float)rad / l1));
            if (i == 0) {
                if (this.closed) {
                    newPoly.add(n0);
                } else {
                    newPoly.add(p0);
                }
            }
            if (!this.closed && i == len - 1) {
                newPoly.add(p1);
            } else {
                newPoly.add(n1);
                newPoly.add(p1, n2);
            }
            ++i;
        }
        return newPoly;
    }

    private int wrapIndex(int i) {
        if (i >= this.path.size()) {
            return i - this.path.size();
        }
        return i;
    }

    private static String str(float f) {
        if (f == (float)Math.round(f)) {
            return Integer.toString(Math.round(f));
        }
        return Float.toString(f);
    }

    private static String str(VectorInterface p) {
        return String.valueOf(Polygon.str(p.getXFloat())) + "," + Polygon.str(p.getYFloat());
    }

    private static final class ClosePath
    implements PathElement {
        private ClosePath() {
        }

        @Override
        public VectorInterface getPoint() {
            return null;
        }

        @Override
        public PathElement transform(Transform transform) {
            return this;
        }

        @Override
        public void drawTo(Path2D path2d) {
            path2d.closePath();
        }

        public String toString() {
            return "Z";
        }

        @Override
        public VectorInterface traverse(VectorInterface start, PointVisitor v) {
            return null;
        }
    }

    private static final class CurveTo
    implements PathElement {
        private final VectorInterface c1;
        private final VectorInterface c2;
        private final VectorInterface p;

        private CurveTo(VectorInterface c1, VectorInterface c2, VectorInterface p) {
            this.c1 = c1;
            this.c2 = c2;
            this.p = p;
        }

        @Override
        public VectorInterface getPoint() {
            return this.p;
        }

        @Override
        public PathElement transform(Transform transform) {
            return new CurveTo(this.c1.transform(transform), this.c2.transform(transform), this.p.transform(transform));
        }

        public String toString() {
            return "C " + Polygon.str(this.c1) + " " + Polygon.str(this.c2) + " " + Polygon.str(this.p);
        }

        @Override
        public void drawTo(Path2D path2d) {
            path2d.curveTo(this.c1.getXFloat(), this.c1.getYFloat(), this.c2.getXFloat(), this.c2.getYFloat(), this.p.getXFloat(), this.p.getYFloat());
        }

        private VectorInterface getPos(VectorInterface start, float t) {
            float omt = 1.0f - t;
            return start.mul(omt * omt * omt).add(this.c1.mul(3.0f * t * omt * omt)).add(this.c2.mul(3.0f * t * t * omt)).add(this.p.mul(t * t * t));
        }

        @Override
        public VectorInterface traverse(VectorInterface start, PointVisitor v) {
            v.visit(this.getPos(start, 0.25f));
            v.visit(this.getPos(start, 0.5f));
            v.visit(this.getPos(start, 0.75f));
            v.visit(this.p);
            return this.p;
        }
    }

    private static class LineTo
    implements PathElement {
        protected final VectorInterface p;

        private LineTo(VectorInterface p) {
            this.p = p;
        }

        private LineTo(PathElement pathElement) {
            this(pathElement.getPoint());
        }

        @Override
        public VectorInterface getPoint() {
            return this.p;
        }

        @Override
        public PathElement transform(Transform transform) {
            return new LineTo(this.p.transform(transform));
        }

        @Override
        public void drawTo(Path2D path2d) {
            path2d.lineTo(this.p.getXFloat(), this.p.getYFloat());
        }

        public String toString() {
            return "L " + Polygon.str(this.p);
        }

        @Override
        public VectorInterface traverse(VectorInterface start, PointVisitor v) {
            v.visit(this.p);
            return this.p;
        }

        /* synthetic */ LineTo(VectorInterface vectorInterface, LineTo lineTo, LineTo lineTo2) {
            this(vectorInterface);
        }
    }

    private static final class MoveTo
    extends LineTo {
        private MoveTo(VectorInterface p) {
            super(p);
        }

        @Override
        public String toString() {
            return "M " + Polygon.str(this.p);
        }

        @Override
        public void drawTo(Path2D path2d) {
            path2d.moveTo(this.p.getXFloat(), this.p.getYFloat());
        }

        @Override
        public PathElement transform(Transform transform) {
            return new MoveTo(this.p.transform(transform));
        }
    }

    public static interface PathElement {
        public VectorInterface getPoint();

        public PathElement transform(Transform var1);

        public void drawTo(Path2D var1);

        public VectorInterface traverse(VectorInterface var1, PointVisitor var2);
    }

    public static interface PointVisitor {
        public void visit(VectorInterface var1);
    }

    private static final class QuadTo
    implements PathElement {
        private final VectorInterface c;
        private final VectorInterface p;

        private QuadTo(VectorInterface c, VectorInterface p) {
            this.c = c;
            this.p = p;
        }

        @Override
        public VectorInterface getPoint() {
            return this.p;
        }

        @Override
        public PathElement transform(Transform transform) {
            return new QuadTo(this.c.transform(transform), this.p.transform(transform));
        }

        public String toString() {
            return "Q " + Polygon.str(this.c) + " " + Polygon.str(this.p);
        }

        @Override
        public void drawTo(Path2D path2d) {
            path2d.quadTo(this.c.getXFloat(), this.c.getYFloat(), this.p.getXFloat(), this.p.getYFloat());
        }

        private VectorInterface getPos(VectorInterface start, float t) {
            float omt = 1.0f - t;
            return start.mul(omt * omt).add(this.c.mul(2.0f * t * omt)).add(this.p.mul(t * t));
        }

        @Override
        public VectorInterface traverse(VectorInterface start, PointVisitor v) {
            v.visit(this.getPos(start, 0.4f));
            v.visit(this.getPos(start, 0.5f));
            v.visit(this.getPos(start, 0.6f));
            v.visit(this.p);
            return this.p;
        }
    }
}

