/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;

public class TransformMatrix
implements Transform {
    final float a;
    final float b;
    final float c;
    final float d;
    final float x;
    final float y;

    public static TransformMatrix rotate(double w) {
        double phi = w / 180.0 * Math.PI;
        float cos = (float)Math.cos(phi);
        float sin = (float)Math.sin(phi);
        return new TransformMatrix(cos, -sin, sin, cos, 0.0f, 0.0f);
    }

    public static TransformMatrix scale(float sx, float sy) {
        return new TransformMatrix(sx, 0.0f, 0.0f, sy, 0.0f, 0.0f);
    }

    public TransformMatrix(float a, float b, float c, float d, float x, float y) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.x = x;
        this.y = y;
    }

    @Override
    public Vector transform(Vector v) {
        return new Vector((int)(v.getXFloat() * this.a + v.getYFloat() * this.b + this.x), (int)(v.getXFloat() * this.c + v.getYFloat() * this.d + this.y));
    }

    @Override
    public VectorFloat transform(VectorFloat v) {
        return new VectorFloat(v.getXFloat() * this.a + v.getYFloat() * this.b + this.x, v.getXFloat() * this.c + v.getYFloat() * this.d + this.y);
    }

    public VectorFloat transformDirection(VectorInterface v) {
        return new VectorFloat(v.getXFloat() * this.a + v.getYFloat() * this.b, v.getXFloat() * this.c + v.getYFloat() * this.d);
    }

    @Override
    public TransformMatrix getMatrix() {
        return this;
    }

    @Override
    public TransformMatrix invert() {
        float q = this.a * this.d - this.b * this.c;
        return new TransformMatrix(this.d / q, -this.b / q, -this.c / q, this.a / q, (this.b * this.y - this.d * this.x) / q, (this.c * this.x - this.a * this.y) / q);
    }

    public boolean isUniform() {
        return TransformMatrix.equal(this.a, this.d) && TransformMatrix.equal(this.b, -this.c);
    }

    public boolean noRotation() {
        return TransformMatrix.equal(this.b, 0.0f) && TransformMatrix.equal(this.c, 0.0f);
    }

    private static boolean equal(float a, float b) {
        return (double)Math.abs(a - b) < 1.0E-7;
    }

    public float[] getValues() {
        return new float[]{this.a, this.b, this.c, this.d, this.x, this.y};
    }
}

