/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.text;

import de.neemann.digital.draw.graphics.text.ParseException;
import de.neemann.digital.draw.graphics.text.text.Blank;
import de.neemann.digital.draw.graphics.text.text.Character;
import de.neemann.digital.draw.graphics.text.text.Decorate;
import de.neemann.digital.draw.graphics.text.text.Sentence;
import de.neemann.digital.draw.graphics.text.text.Simple;
import de.neemann.digital.draw.graphics.text.text.Text;
import java.util.HashMap;

public class Parser {
    private static final HashMap<String, java.lang.Character> COMMANDS = new HashMap();
    private final String text;
    private int pos;

    static {
        COMMANDS.put("sum", java.lang.Character.valueOf('\u2211'));
        COMMANDS.put("prod", java.lang.Character.valueOf('\u220f'));
        COMMANDS.put("wedge", java.lang.Character.valueOf('\u2227'));
        COMMANDS.put("vee", java.lang.Character.valueOf('\u2228'));
        COMMANDS.put("neg", java.lang.Character.valueOf('\u00ac'));
        COMMANDS.put("oplus", java.lang.Character.valueOf('\u2295'));
        COMMANDS.put("odot", java.lang.Character.valueOf('\u2299'));
        COMMANDS.put("pm", java.lang.Character.valueOf('\u00b1'));
        COMMANDS.put("mp", java.lang.Character.valueOf('\u2213'));
        COMMANDS.put("div", java.lang.Character.valueOf('\u00f7'));
        COMMANDS.put("cdot", java.lang.Character.valueOf('\u00b7'));
        COMMANDS.put("times", java.lang.Character.valueOf('\u00d7'));
        COMMANDS.put("otimes", java.lang.Character.valueOf('\u2297'));
    }

    public Parser(String text) {
        this.text = text.trim();
        this.pos = 0;
    }

    private char getChar() throws ParseException {
        char c = this.peekChar();
        ++this.pos;
        return c;
    }

    private char peekChar() throws ParseException {
        if (this.pos >= this.text.length()) {
            throw new ParseException("unexpected EOF");
        }
        return this.text.charAt(this.pos);
    }

    private void expect(char c) throws ParseException {
        if (this.getChar() != c) {
            throw new ParseException("unexpected token " + c);
        }
    }

    private String readWord() throws ParseException {
        StringBuilder sb = new StringBuilder();
        while (this.hasMore() && this.isNormal(this.peekChar())) {
            sb.append(this.getChar());
        }
        return sb.toString();
    }

    private boolean isNormal(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private boolean hasMore() {
        return this.pos < this.text.length();
    }

    public Text parse() throws ParseException {
        return this.parse('\u0000');
    }

    private Text parse(char endChar) throws ParseException {
        Sentence sentence = new Sentence();
        block12: while (this.hasMore() && this.peekChar() != endChar) {
            block0 : switch (this.peekChar()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.getChar();
                    if (sentence.lastIsBlank()) continue block12;
                    sentence.add(Blank.BLANK);
                    break;
                }
                case '~': {
                    this.getChar();
                    sentence.add(new Decorate(this.parseBrace(), Decorate.Style.OVERLINE));
                    break;
                }
                case '$': {
                    this.getChar();
                    sentence.add(new Decorate(this.parse('$'), Decorate.Style.MATH));
                    break;
                }
                case '_': {
                    this.getChar();
                    sentence.getIndex().addSub(this.parseBrace());
                    break;
                }
                case '{': {
                    this.getChar();
                    this.expect('}');
                    break;
                }
                case '^': {
                    this.getChar();
                    sentence.getIndex().addSuper(this.parseBrace());
                    break;
                }
                case '\\': {
                    this.getChar();
                    char p = this.peekChar();
                    switch (p) {
                        case '\\': 
                        case '^': 
                        case '_': {
                            sentence.add(new Character(this.getChar()));
                            break block0;
                        }
                    }
                    String command = this.readWord();
                    java.lang.Character t = COMMANDS.get(command);
                    if (t == null) {
                        sentence.add(new Simple(String.valueOf('\\') + command));
                        break;
                    }
                    sentence.add(new Character(t.charValue()));
                    if (this.peekChar() != ' ') continue block12;
                    this.getChar();
                    break;
                }
                default: {
                    if (this.isNormal(this.peekChar())) {
                        sentence.add(new Simple(this.readWord()).simplify());
                        break;
                    }
                    sentence.add(new Character(this.getChar()));
                }
            }
        }
        if (endChar != '\u0000') {
            this.expect(endChar);
        } else if (this.pos != this.text.length()) {
            throw new ParseException("EOF expected");
        }
        return sentence.simplify();
    }

    private Text parseBrace() throws ParseException {
        if (this.peekChar() == '{') {
            this.getChar();
            return this.parse('}');
        }
        return new Simple(this.readWord());
    }
}

