/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.text.text;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.NamedExpression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.draw.graphics.text.ParseException;
import de.neemann.digital.draw.graphics.text.Parser;
import de.neemann.digital.draw.graphics.text.text.Blank;
import de.neemann.digital.draw.graphics.text.text.Decorate;
import de.neemann.digital.draw.graphics.text.text.Sentence;
import de.neemann.digital.draw.graphics.text.text.Simple;
import de.neemann.digital.draw.graphics.text.text.Text;

public class ExpressionToText {
    private boolean formatIdentifiers = true;

    public ExpressionToText setFormatIdentifiers(boolean formatIdentifiers) {
        this.formatIdentifiers = formatIdentifiers;
        return this;
    }

    public Text createText(Expression expression) {
        return this.createText(expression, FormatToExpression.getDefaultFormat());
    }

    public Text createText(Expression expression, FormatToExpression format) {
        if (expression instanceof Variable) {
            String ident = ((Variable)expression).getIdentifier();
            return this.formatIdent(ident);
        }
        if (expression instanceof Constant) {
            String value = format.constant(((Constant)expression).getValue());
            return new Simple(value);
        }
        if (expression instanceof Operation.And) {
            return this.createOperationText((Operation)expression, format.getAndString(), format);
        }
        if (expression instanceof Operation.Or) {
            return this.createOperationText((Operation)expression, format.getOrString(), format);
        }
        if (expression instanceof Operation.XOr) {
            return this.createOperationText((Operation)expression, format.getXorString(), format);
        }
        if (expression instanceof Not) {
            return new Decorate(this.createText(((Not)expression).getExpression(), format), Decorate.Style.OVERLINE);
        }
        if (expression instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)expression;
            Sentence s = new Sentence();
            s.add(this.formatIdent(ne.getName()));
            s.add(Blank.BLANK);
            s.add(new Simple(format.getEqual()));
            s.add(Blank.BLANK);
            s.add(this.createText(ne.getExpression(), format));
            return s;
        }
        return new Simple(expression.toString());
    }

    private Text formatIdent(String ident) {
        if (this.formatIdentifiers) {
            try {
                return new Parser(ident).parse();
            }
            catch (ParseException e) {
                return new Simple(ident);
            }
        }
        return new Simple(ident);
    }

    private Text createOperationText(Operation op, String opString, FormatToExpression format) {
        Sentence s = new Sentence();
        for (Expression e : op.getExpressions()) {
            if (s.size() > 0) {
                s.add(Blank.BLANK);
                if (!opString.isEmpty()) {
                    s.add(new Simple(opString));
                    s.add(Blank.BLANK);
                }
            }
            if (e instanceof Operation) {
                s.add(new Simple("("));
                s.add(this.createText(e, format));
                s.add(new Simple(")"));
                continue;
            }
            s.add(this.createText(e, format));
        }
        return s;
    }
}

