/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.library;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementFactory;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.LibraryInterface;
import de.neemann.digital.draw.library.ResolveGenerics;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.model.NetList;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.ParserException;
import de.neemann.digital.hdl.hgs.refs.Reference;
import de.neemann.digital.hdl.hgs.refs.ReferenceToStruct;
import de.neemann.digital.hdl.hgs.refs.ReferenceToVar;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;

public final class ElementTypeDescriptionCustom
extends ElementTypeDescription {
    private static final int MAX_DEPTH = 30;
    private final File file;
    private final Circuit circuit;
    private final ResolveGenerics resolveGenerics;
    private final LibraryInterface library;
    private String description;
    private NetList netList;
    private String declarationDefault;

    ElementTypeDescriptionCustom(File file, Circuit circuit, ElementLibrary library) throws PinException {
        super(file.getName(), (ElementFactory)null, circuit.getInputNames());
        this.file = file;
        this.circuit = circuit;
        this.library = library;
        this.resolveGenerics = new ResolveGenerics(circuit, library);
        this.setShortName(file.getName());
        this.addAttribute(Keys.ROTATE);
        this.addAttribute(Keys.LABEL);
        this.addAttribute(Keys.SHAPE_TYPE);
        if (this.isGeneric()) {
            this.addAttribute(Keys.GENERIC);
        }
    }

    public File getFile() {
        return this.file;
    }

    public ElementAttributes getAttributes() {
        return this.circuit.getAttributes();
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public Circuit getResolvedCircuit(ElementAttributes attributes) throws NodeException, ElementNotFoundException {
        if (this.isGeneric()) {
            return this.resolveGenerics.resolveCircuit(attributes).getCircuit();
        }
        return this.circuit;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription(ElementAttributes elementAttributes) {
        if (this.description != null) {
            return this.description;
        }
        return super.getDescription(elementAttributes);
    }

    ModelCreator getModelCreator(LibraryInterface library, String subName, int depth, VisualElement errorVisualElement, VisualElement containingVisualElement) throws PinException, NodeException, ElementNotFoundException {
        if (this.netList == null) {
            this.netList = new NetList(this.circuit);
        }
        if (depth > 30) {
            throw new NodeException(Lang.get("err_recursiveNestingAt_N0", this.circuit.getOrigin()), new ObservableValue[0]);
        }
        if (this.isGeneric()) {
            Circuit c = this.resolveGenerics.resolveCircuit(containingVisualElement.getElementAttributes()).getCircuit();
            return new ModelCreator(c, library, true, new NetList(new NetList(c), errorVisualElement), subName, depth, errorVisualElement);
        }
        return new ModelCreator(this.circuit, library, true, new NetList(this.netList, errorVisualElement), subName, depth, errorVisualElement);
    }

    public String getDeclarationDefault() throws NodeException {
        if (this.declarationDefault == null) {
            this.declarationDefault = ElementTypeDescriptionCustom.createDeclarationDefault(this.circuit);
        }
        return this.declarationDefault;
    }

    public static String createDeclarationDefault(Circuit circuit) throws NodeException {
        TreeSet<String> nameSet = new TreeSet<String>();
        for (VisualElement ve : circuit.getElements()) {
            String gen = ve.getElementAttributes().get(Keys.GENERIC).trim();
            if (gen.isEmpty()) continue;
            try {
                Parser p = new Parser(gen);
                p.enableRefReadCollection();
                p.parse(false);
                for (Reference r : p.getRefsRead()) {
                    ReferenceToVar var;
                    ReferenceToStruct st;
                    if (!(r instanceof ReferenceToStruct) || !((st = (ReferenceToStruct)r).getParent() instanceof ReferenceToVar) || !(var = (ReferenceToVar)st.getParent()).getName().equals("args")) continue;
                    nameSet.add(st.getName());
                }
            }
            catch (ParserException | IOException e) {
                NodeException ex = new NodeException(Lang.get("err_evaluatingGenericsCode_N_N", ve, gen), e);
                ex.setOrigin(circuit.getOrigin());
                throw ex;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String name : nameSet) {
            sb.append(name).append(" := ;\n");
        }
        return sb.toString();
    }

    public boolean isGeneric() {
        return this.circuit.getAttributes().get(Keys.IS_GENERIC);
    }

    @Override
    public PinDescriptions getInputDescription(ElementAttributes elementAttributes) throws NodeException {
        if (this.isGeneric()) {
            try {
                Circuit c = this.resolveGenerics.resolveCircuit(elementAttributes).getCircuit();
                return new PinDescriptions(c.getInputNames());
            }
            catch (Exception e) {
                return super.getInputDescription(elementAttributes);
            }
        }
        return super.getInputDescription(elementAttributes);
    }

    @Override
    public PinDescriptions getOutputDescriptions(ElementAttributes elementAttributes) throws PinException {
        if (this.isGeneric()) {
            try {
                Circuit c = this.resolveGenerics.resolveCircuit(elementAttributes).getCircuit();
                return new PinDescriptions(c.getOutputNames());
            }
            catch (Exception e) {
                return super.getOutputDescriptions(elementAttributes);
            }
        }
        return super.getOutputDescriptions(elementAttributes);
    }
}

