/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.model;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.memory.rom.ROMManagerFile;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.library.CustomElement;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.LibraryInterface;
import de.neemann.digital.draw.library.ResolveGenerics;
import de.neemann.digital.draw.model.ModelEntry;
import de.neemann.digital.draw.model.Net;
import de.neemann.digital.draw.model.NetList;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.gui.components.CircuitModifier;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ModelCreator
implements Iterable<ModelEntry> {
    private final Circuit circuit;
    private final NetList netList;
    private final ArrayList<ModelEntry> entries;
    private final HashMap<String, Pin> ioMap;

    public ModelCreator(Circuit circuit, LibraryInterface library) throws PinException, NodeException, ElementNotFoundException {
        this(ModelCreator.fixGenerics(circuit, library), library, false);
    }

    public static Circuit fixGenerics(Circuit circuit, LibraryInterface library) throws NodeException, ElementNotFoundException {
        if (circuit.getAttributes().get(Keys.IS_GENERIC).booleanValue()) {
            return new ResolveGenerics(circuit, library).resolveCircuit(null).getCircuit();
        }
        return circuit;
    }

    public ModelCreator(Circuit circuit, LibraryInterface library, boolean readAsCustom) throws PinException, NodeException, ElementNotFoundException {
        this(circuit, library, readAsCustom, new NetList(circuit), "", 0, null);
    }

    public ModelCreator(Circuit circuit, LibraryInterface library, boolean isNestedCircuit, NetList netList, String subName, int depth, VisualElement containingVisualElement) throws PinException, NodeException, ElementNotFoundException {
        this.circuit = circuit;
        this.netList = netList;
        this.entries = new ArrayList();
        this.ioMap = isNestedCircuit ? new HashMap() : null;
        if (!isNestedCircuit) {
            this.checkWiresForSplitterConnection(circuit);
        }
        try {
            Iterator<VisualElement> iterator = circuit.getElements().iterator();
            while (iterator.hasNext()) {
                VisualElement ve;
                VisualElement cve = ve = iterator.next();
                if (containingVisualElement != null) {
                    cve = containingVisualElement;
                }
                ElementAttributes attr = ve.getElementAttributes();
                ElementTypeDescription elementType = library.getElementType(ve.getElementName(), attr);
                if (attr.getLabel().contains("*") && !ve.equalsDescription(In.DESCRIPTION) && !ve.equalsDescription(Out.DESCRIPTION)) {
                    attr = new ElementAttributes(attr);
                    attr.set(Keys.LABEL, attr.getLabel().replace("*", subName));
                }
                Element element = elementType.createElement(attr);
                ve.setElement(element);
                Pins pins = ve.getPins();
                pins.bindOutputsToOutputPins(element.getOutputs());
                if (element instanceof Node) {
                    ((Node)((Object)element)).setOrigin(circuit.getOrigin());
                }
                boolean isNotAIO = true;
                if (isNestedCircuit && (elementType == In.DESCRIPTION || elementType == Out.DESCRIPTION || elementType == Clock.DESCRIPTION)) {
                    String label = ve.getElementAttributes().getLabel();
                    if (label == null || label.length() == 0) {
                        throw new PinException(Lang.get("err_pinWithoutName", circuit.getOrigin()), cve);
                    }
                    if (pins.size() != 1) {
                        throw new PinException(Lang.get("err_N_isNotInputOrOutput", label, circuit.getOrigin()), cve);
                    }
                    if (this.ioMap.containsKey(label)) {
                        throw new PinException(Lang.get("err_duplicatePinLabel", label, circuit.getOrigin()), cve);
                    }
                    this.ioMap.put(label, pins.get(0));
                    isNotAIO = false;
                }
                if (isNotAIO) {
                    this.entries.add(new ModelEntry(element, pins, ve, elementType.getInputDescription(ve.getElementAttributes()), isNestedCircuit, circuit.getOrigin(), cve));
                }
                for (Pin p : pins) {
                    netList.add(p);
                }
            }
            ArrayList<ModelCreator> modelCreators = new ArrayList<ModelCreator>();
            Iterator<ModelEntry> it = this.entries.iterator();
            while (it.hasNext()) {
                ModelEntry me = it.next();
                if (!(me.getElement() instanceof CustomElement)) continue;
                CustomElement ce = (CustomElement)me.getElement();
                ModelCreator child = ce.getModelCreator(library, this.combineNames(subName, me.getVisualElement().getElementAttributes().getLabel()), depth + 1, containingVisualElement != null ? containingVisualElement : me.getVisualElement(), me.getVisualElement());
                modelCreators.add(child);
                HashMap<Net, Net> netMatch = new HashMap<Net, Net>();
                for (Pin p : me.getPins()) {
                    Net childNet = child.getNetOfIOAndRemove(p);
                    if (childNet == null) continue;
                    Net otherParentNet = (Net)netMatch.get(childNet);
                    if (otherParentNet != null) {
                        Pin insertedPin = child.getPinOfIO(p.getName());
                        otherParentNet.removePin(insertedPin);
                        Net parentNet = netList.getNetOfPin(p);
                        if (parentNet == null) continue;
                        parentNet.removePin(p);
                        if (otherParentNet == parentNet) continue;
                        otherParentNet.addNet(parentNet);
                        netList.remove(parentNet);
                        continue;
                    }
                    Net parentNet = netList.getNetOfPin(p);
                    if (parentNet == null) continue;
                    parentNet.removePin(p);
                    parentNet.addAll(childNet.getPins());
                    netMatch.put(childNet, parentNet);
                }
                for (Net childNet : netMatch.keySet()) {
                    child.remove(childNet);
                }
                it.remove();
            }
            for (ModelCreator md : modelCreators) {
                this.entries.addAll(md.entries);
                netList.add(md.netList);
            }
        }
        catch (NodeException | PinException e) {
            e.setOrigin(circuit.getOrigin());
            e.setVisualElement(containingVisualElement);
            throw e;
        }
    }

    private void checkWiresForSplitterConnection(Circuit circuit) {
        HashSet<Vector> posSet = new HashSet<Vector>();
        for (VisualElement e : circuit.getElements()) {
            if (!e.equalsDescription(Splitter.DESCRIPTION)) continue;
            for (Pin p : e.getPins()) {
                posSet.add(p.getPos());
            }
        }
        for (Wire w : circuit.getWires()) {
            w.setIsConnectedToSplitter(posSet.contains(w.p1) || posSet.contains(w.p2));
        }
    }

    private String combineNames(String s1, String s2) {
        if (s1.length() > 0) {
            if (s2.length() > 0) {
                return String.valueOf(s1) + "-" + s2;
            }
            return s1;
        }
        return s2;
    }

    private void remove(Net childNet) {
        this.netList.remove(childNet);
    }

    private Pin getPinOfIO(String name) throws PinException {
        Pin pin = this.ioMap.get(name);
        if (pin == null) {
            throw new PinException(Lang.get("err_pin_N_notFound", name));
        }
        return pin;
    }

    private Net getNetOfIOAndRemove(Pin p) throws PinException {
        Pin pin = this.getPinOfIO(p.getName());
        Net netOfPin = this.netList.getNetOfPin(pin);
        if (netOfPin == null) {
            if (p.getDirection() == PinDescription.Direction.input) {
                return null;
            }
            throw new PinException(Lang.get("err_netOfPin_N_notFound", p.getName()));
        }
        netOfPin.removePin(pin);
        return netOfPin;
    }

    public Model createModel(boolean attachWires) throws PinException, NodeException {
        Model m = new Model().setRootPath(this.circuit.getOrigin()).setAllowGlobalValues(attachWires).setOscillationDetectionCounter(this.circuit.getAttributes().get(Keys.OSCILLATION_DETECTION_COUNTER));
        for (Net n : this.netList) {
            n.interconnect(m, attachWires);
        }
        for (ModelEntry e : this.entries) {
            e.applyInputs();
        }
        for (ModelEntry e : this.entries) {
            e.getElement().registerNodes(m);
        }
        for (ModelEntry e : this.entries) {
            e.getElement().init(m);
            e.getVisualElement().getShape().registerModel(this, m, e);
        }
        ROMManagerFile romManager = this.circuit.getAttributes().get(Keys.ROMMANAGER);
        romManager.applyTo(m, this.circuit.getOrigin());
        return m;
    }

    public void connectToGui(CircuitModifier circuitModifier) {
        for (ModelEntry e : this.entries) {
            e.connectToGui(circuitModifier);
        }
    }

    public void addNodeElementsTo(Collection<Node> nodes, Collection<Drawable> highLighted) {
        if (nodes == null) {
            return;
        }
        HashSet<Node> nodeSet = new HashSet<Node>(nodes);
        for (ModelEntry me : this.entries) {
            Element element = me.getElement();
            if (!(element instanceof Node) || !nodeSet.contains(element)) continue;
            highLighted.add(me.getContainingVisualElement());
        }
    }

    @Override
    public Iterator<ModelEntry> iterator() {
        return this.entries.iterator();
    }

    public List<ModelEntry> getEntries(String elementName) {
        ArrayList<ModelEntry> entry = new ArrayList<ModelEntry>();
        for (ModelEntry me : this.entries) {
            if (!me.getVisualElement().getElementName().endsWith(elementName)) continue;
            entry.add(me);
        }
        return entry;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }
}

