/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.model;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.wiring.bus.DataBus;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class Net {
    private static final ObservableValue UNCONNECTED_WIRE = new ObservableValue("unconnected wire", 1).setToHighZ().setConstant();
    private final HashSet<Vector> points;
    private final ArrayList<Pin> pins;
    private final ArrayList<Wire> wires;
    private final HashSet<String> labelSet;
    private File origin;
    private VisualElement visualElement;
    private HashMap<Pin, Net> pinMap;

    public Net(Net toCopy, VisualElement visualElement) {
        this.points = toCopy.points;
        this.visualElement = visualElement;
        this.wires = null;
        this.pins = new ArrayList<Pin>(toCopy.pins);
        this.labelSet = new HashSet<String>(toCopy.labelSet);
        this.origin = toCopy.origin;
    }

    public Net(Wire w) {
        this.points = new HashSet();
        this.points.add(w.p1);
        this.points.add(w.p2);
        this.pins = new ArrayList();
        this.wires = new ArrayList();
        this.wires.add(w);
        this.labelSet = new HashSet();
    }

    public Net(Vector v) {
        this.points = new HashSet();
        this.points.add(v);
        this.pins = new ArrayList();
        this.wires = null;
        this.labelSet = new HashSet();
    }

    public Vector tryMerge(Wire wire) {
        if (this.points.contains(wire.p1)) {
            this.wires.add(wire);
            this.points.add(wire.p2);
            return wire.p2;
        }
        if (this.points.contains(wire.p2)) {
            this.wires.add(wire);
            this.points.add(wire.p1);
            return wire.p1;
        }
        return null;
    }

    public boolean contains(Vector vector) {
        return this.points.contains(vector);
    }

    void addPointsTo(HashMap<Vector, Net> set) {
        for (Vector p : this.points) {
            set.put(p, this);
        }
    }

    void addAllPointsFrom(Net changedNet) {
        this.points.addAll(changedNet.points);
        if (this.wires != null && changedNet.wires != null) {
            this.wires.addAll(changedNet.wires);
        }
        this.labelSet.addAll(changedNet.labelSet);
    }

    public void add(Pin pin) {
        this.pins.add(pin);
    }

    public void addAll(Collection<Pin> pins) {
        this.pins.addAll(pins);
        if (this.pinMap != null) {
            for (Pin p : pins) {
                this.pinMap.put(p, this);
            }
        }
    }

    public void addNet(Net otherNet) {
        ArrayList<Pin> pins = otherNet.getPins();
        this.pins.addAll(pins);
        if (this.pinMap != null) {
            for (Pin p : pins) {
                this.pinMap.put(p, this);
            }
        }
        if (this.wires != null && otherNet.getWires() != null) {
            this.wires.addAll(otherNet.getWires());
        }
        this.labelSet.addAll(otherNet.labelSet);
    }

    public void interconnect(Model m, boolean attachWires) throws PinException {
        ArrayList<Pin> inputs = new ArrayList<Pin>();
        ArrayList<Pin> outputs = new ArrayList<Pin>();
        for (Pin p : this.pins) {
            if (p.getDirection() == PinDescription.Direction.input) {
                inputs.add(p);
                continue;
            }
            outputs.add(p);
        }
        if (outputs.size() == 0 && inputs.size() > 0) {
            throw new PinException(Lang.get("err_noOutConnectedToWire", this.toString()), this);
        }
        ObservableValue value = outputs.size() == 1 && ((Pin)outputs.get(0)).getPullResistor() == PinDescription.PullResistor.none ? outputs.get(0).getValue() : (inputs.size() == 0 && outputs.size() == 0 ? UNCONNECTED_WIRE : new DataBus(this, m, outputs).getReadableOutput());
        if (outputs.size() > 1) {
            for (Pin o : outputs) {
                ObservableValue ov = o.getValue();
                if (!ov.isConstant() || !ov.isHighZ()) continue;
                throw new PinException(Lang.get("err_notConnectedNotAllowed", o), this);
            }
        }
        if (value == null) {
            throw new PinException(Lang.get("err_output_N_notDefined", outputs.get(0)), this);
        }
        for (Pin i : inputs) {
            i.setValue(value);
        }
        for (Pin o : outputs) {
            o.setReaderValue(value);
        }
        if (this.wires != null && attachWires) {
            for (Wire w : this.wires) {
                w.setValue(value);
            }
        }
    }

    public ArrayList<Wire> getWires() {
        return this.wires;
    }

    public boolean containsPin(Pin p) {
        return this.pins.contains(p);
    }

    public ArrayList<Pin> getPins() {
        return this.pins;
    }

    public void removePin(Pin p) throws PinException {
        if (this.pinMap != null) {
            this.pinMap.remove(p);
        }
        if (!this.pins.remove(p)) {
            throw new PinException(Lang.get("err_pinNotPresent", new Object[0]), this);
        }
    }

    public void addLabel(String label) {
        this.labelSet.add(label);
    }

    public boolean matchesLabel(Net net) {
        for (String l : this.labelSet) {
            if (!net.labelSet.contains(l)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.labelSet.isEmpty()) {
            return this.pins.toString();
        }
        return this.labelSet + "/" + this.pins;
    }

    public void setOrigin(File origin) {
        this.origin = origin;
    }

    public File getOrigin() {
        return this.origin;
    }

    public VisualElement getVisualElement() {
        return this.visualElement;
    }

    public HashSet<String> getLabels() {
        return this.labelSet;
    }

    void addPinsTo(HashMap<Pin, Net> pinMap) {
        this.pinMap = pinMap;
        for (Pin p : this.pins) {
            pinMap.put(p, this);
        }
    }
}

