/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.model;

import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Tunnel;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.model.Net;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class NetList
implements Iterable<Net> {
    private final ArrayList<Net> netList = new ArrayList();
    private HashMap<Vector, Net> posMap;
    private HashMap<Pin, Net> pinMap;

    public NetList(Circuit circuit) throws PinException {
        for (Wire w : circuit.getWires()) {
            this.add(w);
        }
        HashSet<Vector> allPinPositions = new HashSet<Vector>();
        HashSet<Vector> directConnection = new HashSet<Vector>();
        for (VisualElement ve : circuit.getElements()) {
            for (Object p : ve.getPins()) {
                Vector v = ((Pin)p).getPos();
                if (allPinPositions.contains(v)) {
                    directConnection.add(v);
                    continue;
                }
                allPinPositions.add(v);
            }
        }
        HashMap<Vector, Net> allNetPositions = this.getAllNetPositions();
        for (Vector v : directConnection) {
            if (allNetPositions.containsKey(v)) continue;
            Net net = new Net(v);
            this.netList.add(net);
            allNetPositions.put(v, net);
        }
        boolean hasLabel = false;
        for (VisualElement ve : circuit.getElements()) {
            String label;
            if (!ve.equalsDescription(Tunnel.DESCRIPTION) || (label = ve.getElementAttributes().get(Keys.NETNAME).trim()).isEmpty()) continue;
            Net found = allNetPositions.get(ve.getPos());
            if (found == null) {
                PinException e = new PinException(Lang.get("err_labelNotConnectedToNet_N", label), ve);
                e.setOrigin(circuit.getOrigin());
                throw e;
            }
            found.addLabel(label);
            hasLabel = true;
        }
        if (hasLabel) {
            this.mergeLabels();
        }
        for (Net n : this.netList) {
            n.setOrigin(circuit.getOrigin());
        }
    }

    private void mergeLabels() {
        ArrayList<Net> oldNetList = new ArrayList<Net>(this.netList);
        this.netList.clear();
        HashMap<String, Net> map = new HashMap<String, Net>();
        block4: for (Net n : oldNetList) {
            HashSet<String> labels = n.getLabels();
            switch (labels.size()) {
                case 0: {
                    this.netList.add(n);
                    break;
                }
                case 1: {
                    String label = labels.iterator().next();
                    Net net = (Net)map.get(label);
                    if (net == null) {
                        this.netList.add(n);
                        map.put(label, n);
                        break;
                    }
                    net.addAllPointsFrom(n);
                    for (String l : n.getLabels()) {
                        map.put(l, net);
                    }
                    continue block4;
                }
                default: {
                    Net net;
                    for (String la : new ArrayList<String>(labels)) {
                        net = (Net)map.get(la);
                        if (net == null) continue;
                        n.addAllPointsFrom(net);
                        this.netList.remove(net);
                    }
                    this.netList.add(n);
                    for (String l : n.getLabels()) {
                        map.put(l, n);
                    }
                    continue block4;
                }
            }
        }
    }

    public NetList(NetList toCopy, VisualElement visualElement) {
        for (Net net : toCopy) {
            this.netList.add(new Net(net, visualElement));
        }
    }

    public void add(NetList netList) {
        this.netList.addAll(netList.netList);
        if (this.pinMap != null) {
            this.pinMap.putAll(netList.pinMap);
        }
    }

    public void add(Pin pin) {
        Net net;
        if (this.posMap == null) {
            this.posMap = this.getAllNetPositions();
        }
        if ((net = this.posMap.get(pin.getPos())) != null) {
            net.add(pin);
        }
    }

    private void add(Wire w) {
        for (Net net : this.netList) {
            Vector added = net.tryMerge(w);
            if (added == null) continue;
            this.netChanged(net, added);
            return;
        }
        this.netList.add(new Net(w));
    }

    private void netChanged(Net changedNet, Vector added) {
        for (Net n : this.netList) {
            if (n == changedNet || !n.contains(added)) continue;
            n.addAllPointsFrom(changedNet);
            this.netList.remove(changedNet);
            return;
        }
    }

    public int size() {
        return this.netList.size();
    }

    @Override
    public Iterator<Net> iterator() {
        return this.netList.iterator();
    }

    public Net getNetOfPin(Pin p) {
        if (this.pinMap == null) {
            this.pinMap = new HashMap();
            for (Net n : this.netList) {
                n.addPinsTo(this.pinMap);
            }
        }
        return this.pinMap.get(p);
    }

    public Net getNetOfPos(Vector pos) {
        for (Net n : this.netList) {
            if (!n.contains(pos)) continue;
            return n;
        }
        return null;
    }

    private HashMap<Vector, Net> getAllNetPositions() {
        HashMap<Vector, Net> map = new HashMap<Vector, Net>();
        for (Net n : this.netList) {
            n.addPointsTo(map);
        }
        return map;
    }

    public void remove(Net childNet) {
        this.netList.remove(childNet);
        for (Pin p : childNet.getPins()) {
            if (this.pinMap.get(p) != childNet) continue;
            this.pinMap.remove(p);
        }
    }
}

