/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.model;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.gui.StatusInterface;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealTimeClock
implements ModelStateObserverTyped {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealTimeClock.class);
    private final Model model;
    private final ScheduledThreadPoolExecutor executor;
    private final StatusInterface status;
    private final int frequency;
    private final ObservableValue output;
    private Runner runner;

    public RealTimeClock(Model model, Clock clock, ScheduledThreadPoolExecutor executor, StatusInterface status) {
        this.model = model;
        this.executor = executor;
        this.status = status;
        int f = clock.getFrequency();
        if (f < 1) {
            f = 1;
        }
        this.frequency = f;
        this.output = clock.getClockOutput();
        model.addObserver(this);
    }

    @Override
    public void handleEvent(ModelEvent event) {
        switch (event.getType()) {
            case STARTED: {
                int delayMuS = 500000 / this.frequency;
                if (delayMuS < 1) {
                    this.runner = new ThreadRunner();
                    break;
                }
                this.runner = new RealTimeRunner(delayMuS);
                break;
            }
            case CLOSED: {
                if (this.runner == null) break;
                this.runner.stop();
            }
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return new ModelEventType[]{ModelEventType.STARTED, ModelEventType.CLOSED};
    }

    public boolean isThreadRunner() {
        int delayMuS = 500000 / this.frequency;
        return delayMuS < 1;
    }

    private static final class FrequencyCalculator {
        private final StatusInterface status;
        private final long minCounter;
        private long checkCounter;
        private int counter;
        private long time;

        private FrequencyCalculator(StatusInterface status, int frequency) {
            this.status = status;
            this.time = System.currentTimeMillis();
            this.counter = 0;
            this.checkCounter = this.minCounter = (long)Math.min(frequency, 50000);
        }

        private void calc() {
            ++this.counter;
            if ((long)this.counter == this.checkCounter) {
                long t = System.currentTimeMillis();
                if (t - this.time > 2000L) {
                    long l = (long)this.counter / (t - this.time) / 2L;
                    this.status.setStatus(String.valueOf(l) + " kHz");
                    this.time = t;
                    this.counter = 0;
                    this.checkCounter = this.minCounter;
                } else {
                    this.checkCounter += this.minCounter;
                }
            }
        }
    }

    private class RealTimeRunner
    implements Runner {
        private final ScheduledFuture<?> timer;

        RealTimeRunner(int delay) {
            FrequencyCalculator frequencyCalculator = RealTimeClock.this.frequency > 2000 && RealTimeClock.this.status != null ? new FrequencyCalculator(RealTimeClock.this.status, RealTimeClock.this.frequency) : null;
            this.timer = RealTimeClock.this.executor.scheduleAtFixedRate(() -> {
                RealTimeClock.this.model.modify(() -> {
                    ObservableValue observableValue = RealTimeClock.this.output.setValue(1L - RealTimeClock.this.output.getValue());
                });
                if (frequencyCalculator != null) {
                    frequencyCalculator.calc();
                }
            }, delay, delay, TimeUnit.MICROSECONDS);
        }

        @Override
        public void stop() {
            if (this.timer != null) {
                this.timer.cancel(false);
            }
        }
    }

    static interface Runner {
        public void stop();
    }

    private class ThreadRunner
    implements Runner {
        private final Thread thread = new Thread(() -> {
            LOGGER.debug("thread start");
            FrequencyCalculator frequencyCalculator = null;
            if (RealTimeClock.this.status != null) {
                frequencyCalculator = new FrequencyCalculator(RealTimeClock.this.status, RealTimeClock.this.frequency);
            }
            while (!Thread.interrupted()) {
                RealTimeClock.this.model.modify(() -> {
                    ObservableValue observableValue = RealTimeClock.this.output.setValue(1L - RealTimeClock.this.output.getValue());
                });
                if (frequencyCalculator == null) continue;
                frequencyCalculator.calc();
            }
        });

        ThreadRunner() {
            this.thread.setDaemon(true);
            this.thread.start();
        }

        @Override
        public void stop() {
            this.thread.interrupt();
        }
    }
}

