/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.io.Button;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.gui.components.CircuitComponent;
import java.awt.Point;

public class ButtonShape
implements Shape {
    protected static final int HEIGHT = 7;
    private final String label;
    private final PinDescriptions outputs;
    private boolean centerLabel;
    private Button button;

    public ButtonShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        this.label = attr.getLabel();
        this.setCenterLabel(attr.get(Keys.MAP_TO_KEY) != false && this.label.length() == 1);
    }

    protected void setCenterLabel(boolean center) {
        this.centerLabel = center;
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.outputs.get(0)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.button = (Button)ioState.getElement();
        return new InteractorInterface(){

            @Override
            public void clicked(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
            }

            @Override
            public void pressed(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
                modelSync.modify(() -> ButtonShape.this.button.setPressed(true));
            }

            @Override
            public void released(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
                modelSync.modify(() -> ButtonShape.this.button.setPressed(false));
            }

            @Override
            public void dragged(CircuitComponent cc, Point posOnScreen, Vector pos, Transform trans, IOState ioState, Element element, SyncAccess modelSync) {
            }
        };
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        boolean isPressed = false;
        if (this.button != null) {
            isPressed = this.button.isPressed();
        }
        if (isPressed) {
            graphic.drawPolygon(new Polygon(true).add(-31, -15).add(-1, -15).add(-1, 15).add(-31, 15), Style.NORMAL);
        } else {
            int t = Style.NORMAL.getThickness() / 4;
            graphic.drawPolygon(new Polygon(true).add(-38, -22).add(-8, -22).add(-1, -15).add(-1, 15).add(-31, 15).add(-38, 8), Style.NORMAL);
            graphic.drawPolygon(new Polygon(false).add(-8, -15 + t - 7).add(-8, 8).add(t - 30 - 1 - 7, 8), Style.NORMAL);
            graphic.drawLine(new Vector(-8, 8), new Vector(-1 - t, 15 - t), Style.NORMAL);
        }
        if (this.centerLabel) {
            Vector center = this.getButtonCenter(isPressed);
            graphic.drawText(center, this.label, Orientation.CENTERCENTER, Style.NORMAL);
        } else {
            Vector textPos = new Vector(-45, -4);
            graphic.drawText(textPos, this.label, Orientation.RIGHTCENTER, Style.NORMAL);
        }
    }

    protected Vector getButtonCenter(boolean pressed) {
        Vector center = pressed ? new Vector(-16, 0) : new Vector(-23, -7);
        return center;
    }
}

