/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.OutputShape;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.gui.components.CircuitComponent;
import java.awt.Point;

public class ClockShape
implements Shape {
    private final String label;
    private final PinDescriptions outputs;
    private final boolean small;

    public ClockShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        String pinNumber = attr.get(Keys.PINNUMBER);
        this.label = pinNumber.length() == 0 ? attr.getLabel() : String.valueOf(attr.getLabel()) + " (" + pinNumber + ")";
        this.small = attr.get(Keys.IN_OUT_SMALL);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.outputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return new Interactor(){

            @Override
            public void clicked(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
                ObservableValue value = ioState.getOutput(0);
                if (value.getBits() == 1) {
                    modelSync.modify(() -> {
                        ObservableValue observableValue2 = value.setValue(1L - value.getValue());
                    });
                }
            }
        };
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        Vector wavePos;
        int waveSize = 5;
        if (graphic.isFlagSet(Graphic.Flag.smallIO)) {
            Vector center = new Vector(-OutputShape.LATEX_RAD.x, 0);
            graphic.drawCircle(center.sub(OutputShape.LATEX_RAD), center.add(OutputShape.LATEX_RAD), Style.NORMAL);
            Vector textPos = new Vector(-10 - OutputShape.LATEX_RAD.x, 0);
            graphic.drawText(textPos, this.label, Orientation.RIGHTCENTER, Style.INOUT);
            wavePos = center.sub(new Vector(2 * waveSize, OutputShape.LATEX_RAD.y + waveSize + 1));
        } else {
            int outSize = OutputShape.getOutSize(this.small);
            waveSize = outSize / 3;
            graphic.drawPolygon(new Polygon(true).add(-outSize * 2 - 1, -outSize).add(-1, -outSize).add(-1, outSize).add(-outSize * 2 - 1, outSize), Style.NORMAL);
            Vector textPos = new Vector(-outSize * 3, 0);
            graphic.drawText(textPos, this.label, Orientation.RIGHTCENTER, Style.INOUT);
            wavePos = new Vector(-outSize - waveSize * 2, waveSize);
        }
        graphic.drawPolygon(new Polygon(false).add(wavePos).add(wavePos.add(waveSize, 0)).add(wavePos.add(waveSize, -waveSize * 2)).add(wavePos.add(2 * waveSize, -waveSize * 2)).add(wavePos.add(2 * waveSize, 0)).add(wavePos.add(3 * waveSize, 0)).add(wavePos.add(3 * waveSize, -waveSize * 2)).add(wavePos.add(4 * waveSize, -waveSize * 2)), Style.THIN);
    }
}

