/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class DriverShape
implements Shape {
    private final boolean bottom;
    private final boolean invertedInput;
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final boolean invertedOutput;
    private Pins pins;

    public DriverShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this(attr, inputs, outputs, false);
    }

    public DriverShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs, boolean invertedInput) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.bottom = attr.get(Keys.FLIP_SEL_POSITON);
        this.invertedInput = invertedInput;
        this.invertedOutput = attr.get(Keys.INVERT_DRIVER_OUTPUT);
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins();
            this.pins.add(new Pin(new Vector(-20, 0), (PinDescription)this.inputs.get(0)));
            this.pins.add(new Pin(new Vector(0, this.bottom ? 20 : -20), (PinDescription)this.inputs.get(1)));
            if (this.invertedOutput) {
                this.pins.add(new Pin(new Vector(40, 0), (PinDescription)this.outputs.get(0)));
            } else {
                this.pins.add(new Pin(new Vector(20, 0), (PinDescription)this.outputs.get(0)));
            }
        }
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        graphic.drawPolygon(new Polygon(true).add(-19, -12).add(19, 0).add(-19, 12), Style.NORMAL);
        if (this.bottom) {
            if (this.invertedInput) {
                graphic.drawCircle(new Vector(-6, 20), new Vector(6, 8), Style.NORMAL);
            } else {
                graphic.drawLine(new Vector(0, 20), new Vector(0, 7), Style.NORMAL);
            }
        } else if (this.invertedInput) {
            graphic.drawCircle(new Vector(-6, -20), new Vector(6, -8), Style.NORMAL);
        } else {
            graphic.drawLine(new Vector(0, -20), new Vector(0, -7), Style.NORMAL);
        }
        if (this.invertedOutput) {
            graphic.drawCircle(new Vector(21, -6), new Vector(33, 6), Style.NORMAL);
            graphic.drawLine(new Vector(33, 0), new Vector(40, 0), Style.NORMAL);
        }
    }
}

