/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.DILShape;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class FuseShape
implements Shape {
    private static final int BEZ = Math.round(5.0f * DILShape.CIRC);
    private static final Polygon OK_POLY = new Polygon(false).add(0, 0).add(new Vector(0, -BEZ), new Vector(5 - BEZ, -5), new Vector(5, -5)).add(new Vector(5 + BEZ, -5), new Vector(10, -5 + BEZ), new Vector(10, 0)).add(new Vector(10, BEZ), new Vector(15 - BEZ, 5), new Vector(15, 5)).add(new Vector(15 + BEZ, 5), new Vector(20, 5 - BEZ), new Vector(20, 0));
    private static final Polygon BLOWN_POLY1 = new Polygon(false).add(0, 0).add(new Vector(0, -BEZ), new Vector(5 - BEZ, -5), new Vector(5, -5));
    private static final Polygon BLOWN_POLY2 = new Polygon(false).add(15, 5).add(new Vector(15 + BEZ, 5), new Vector(20, 5 - BEZ), new Vector(20, 0));
    private final PinDescriptions outputs;
    private final boolean blown;

    public FuseShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        this.blown = attr.get(Keys.BLOWN);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.outputs.get(0))).add(new Pin(new Vector(20, 0), (PinDescription)this.outputs.get(1)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        if (this.blown) {
            graphic.drawPolygon(BLOWN_POLY1, Style.THIN);
            graphic.drawPolygon(BLOWN_POLY2, Style.THIN);
        } else {
            graphic.drawPolygon(OK_POLY, Style.THIN);
        }
    }
}

