/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class LEDShape
implements Shape {
    private final String label;
    private final PinDescriptions inputs;
    private final int size;
    private Style onStyle;
    private IOState ioState;
    private Value value;

    public LEDShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.label = attr.getLabel();
        int s = attr.get(Keys.LED_SIZE);
        this.size = s > 0 ? s * 15 : 10;
        this.onStyle = Style.NORMAL.deriveFillStyle(attr.get(Keys.COLOR));
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.ioState = ioState;
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.ioState != null) {
            this.value = this.ioState.getInput(0).getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        boolean fill = true;
        if (this.value != null) {
            fill = false;
            if (!this.value.isHighZ() && this.value.getValue() != 0L) {
                fill = true;
            }
        }
        Vector rad = new Vector(this.size - 2, this.size - 2);
        Vector radL = new Vector(this.size, this.size);
        Vector center = new Vector(1 + this.size, 0);
        graphic.drawCircle(center.sub(radL), center.add(radL), Style.FILLED);
        if (fill) {
            graphic.drawCircle(center.sub(rad), center.add(rad), this.onStyle);
        }
        Vector textPos = new Vector(2 * this.size + 15, 0);
        graphic.drawText(textPos, this.label, Orientation.LEFTCENTER, Style.NORMAL);
    }
}

