/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.GraphicRestyle;
import de.neemann.digital.draw.graphics.GraphicTransform;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.TransformTranslate;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.library.GenericCode;
import de.neemann.digital.draw.library.GenericInitCode;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseElement;
import java.util.HashMap;
import java.util.HashSet;

public class MinimizedShape
implements Shape {
    private static final HashSet<String> IGNORE_SET = new HashSet();
    private final Pins pins;
    private final Circuit circuit;
    private final Vector min;
    private final Polygon outer;
    private final String name;
    private final Vector textPos;
    private final Vector labelPos;
    private final String label;

    static {
        IGNORE_SET.add(In.DESCRIPTION.getName());
        IGNORE_SET.add(Out.DESCRIPTION.getName());
        IGNORE_SET.add(Clock.DESCRIPTION.getName());
        IGNORE_SET.add(GenericCode.DESCRIPTION.getName());
        IGNORE_SET.add(GenericInitCode.DESCRIPTION.getName());
        IGNORE_SET.add(TestCaseElement.DESCRIPTION.getName());
    }

    public MinimizedShape(ElementTypeDescriptionCustom custom, ElementAttributes elementAttributes) throws NodeException, ElementNotFoundException, PinException {
        this.name = custom.getShortName();
        this.label = elementAttributes.getLabel();
        this.circuit = custom.getResolvedCircuit(elementAttributes);
        HashMap<String, Vector> pinMap = new HashMap<String, Vector>();
        for (VisualElement ve : this.circuit.getElements()) {
            if (ve.equalsDescription(In.DESCRIPTION) || ve.equalsDescription(Clock.DESCRIPTION)) {
                this.addToMap(pinMap, ve);
            }
            if (!ve.equalsDescription(Out.DESCRIPTION)) continue;
            this.addToMap(pinMap, ve);
        }
        boolean first = true;
        int minX = 0;
        int minY = 0;
        for (Object p : pinMap.values()) {
            if (first) {
                minX = ((Vector)p).x;
                minY = ((Vector)p).y;
                first = false;
                continue;
            }
            if (((Vector)p).x < minX) {
                minX = ((Vector)p).x;
            }
            if (((Vector)p).y >= minY) continue;
            minY = ((Vector)p).y;
        }
        this.min = new Vector(minX, minY);
        this.pins = new Pins();
        for (Object p : custom.getInputDescription(elementAttributes)) {
            this.pins.add(new Pin(this.toGrid(pinMap.get(p.getName())), (PinDescription)p));
        }
        for (Object p : custom.getOutputDescriptions(elementAttributes)) {
            this.pins.add(new Pin(this.toGrid(pinMap.get(p.getName())), (PinDescription)p));
        }
        GraphicMinMax minMax = new GraphicMinMax();
        this.drawCircuitTo(minMax);
        for (Pin p : this.pins) {
            minMax.check(p.getPos().mul(2).add(this.min));
        }
        this.outer = new Polygon(true).add(new Vector(minMax.getMin().x, minMax.getMin().y - 10)).add(new Vector(minMax.getMin().x, minMax.getMax().y + 10)).add(new Vector(minMax.getMax().x, minMax.getMax().y + 10)).add(new Vector(minMax.getMax().x, minMax.getMin().y - 10));
        int x = (minMax.getMin().x + minMax.getMax().x) / 2;
        this.labelPos = new Vector(x, minMax.getMin().y - 10).sub(this.min).div(2).add(0, -5);
        this.textPos = new Vector(x, minMax.getMax().y + 10).sub(this.min).div(2).add(0, 5);
    }

    private void addToMap(HashMap<String, Vector> pinMap, VisualElement ve) throws PinException {
        String label = ve.getElementAttributes().getLabel();
        if (pinMap.containsKey(label)) {
            throw new PinException(Lang.get("err_duplicatePinLabel", label, this.name));
        }
        pinMap.put(label, ve.getPos());
    }

    private Vector toGrid(VectorInterface pos) {
        pos = pos.sub(this.min).div(2);
        return new Vector(Math.round(pos.getXFloat() / 20.0f) * 20, Math.round(pos.getYFloat() / 20.0f) * 20);
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Graphic gr = new GraphicTransform(graphic, Transform.mul(new TransformTranslate(this.min.mul(-1)), TransformMatrix.scale(0.5f, 0.5f)));
        gr = new GraphicRestyle(gr){

            @Override
            public Style getStyle(Style style) {
                if (style != Style.DASH) {
                    return Style.THIN;
                }
                return style;
            }

            @Override
            public Style getFontStyle(Style style) {
                return Style.THIN.deriveFontStyle(style.getFontSize() / 2, false);
            }
        };
        this.drawCircuitTo(gr);
        gr.drawPolygon(this.outer, Style.DASH);
        if (this.label != null && this.label.length() > 0) {
            graphic.drawText(this.labelPos, this.label, Orientation.CENTERBOTTOM, Style.NORMAL);
        }
        if (this.name.length() > 0) {
            graphic.drawText(this.textPos, this.name, Orientation.CENTERTOP, Style.SHAPE_PIN);
        }
    }

    private void drawCircuitTo(Graphic gr) {
        for (Wire w : this.circuit.getWires()) {
            gr.drawLine(w.p1, w.p2, Style.THIN);
        }
        for (VisualElement ve : this.circuit.getElements()) {
            if (IGNORE_SET.contains(ve.getElementName())) continue;
            ve.drawTo(gr, null);
        }
    }

    @Override
    public Pins getPins() {
        return this.pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }
}

